/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.tape;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import jmce.sim.TapePulse;
import jmce.sim.tape.TapeData;
import jmce.sim.tape.TapeFileDecoder;
import jmce.util.Hex;
import jmce.util.Logger;

public class TapeTZX
implements TapeFileDecoder {
    private static Logger log = Logger.getLogger(TapeTZX.class);
    private static final int clock = 3500000;

    @Override
    public boolean isFileSupported(InputStream is) throws IOException {
        byte[] header = new byte[10];
        if (is.read(header) != 10) {
            return false;
        }
        String signature = new String(header, 0, 7);
        if (!signature.equals("ZXTape!")) {
            log.info("Signature '" + signature + "' unsupported");
            return false;
        }
        return true;
    }

    private int get3byte(InputStream is) throws IOException {
        int n = is.read();
        n |= is.read() << 8;
        return n |= is.read() << 16;
    }

    private int getWord(InputStream is) throws IOException {
        int low = is.read();
        int hi = is.read();
        return low | hi << 8;
    }

    private void skip(InputStream is, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            is.read();
        }
    }

    @Override
    public TapeData decode(BufferedInputStream is) throws IOException {
        int id;
        log.info("Start decoding");
        TapeData data = new TapeData(3500000);
        block13: while ((id = is.read()) != -1) {
            log.info("Block id " + Hex.formatByte(id));
            switch (id) {
                case 16: {
                    this.block10(data, is);
                    continue block13;
                }
                case 18: {
                    this.block12(data, is);
                    continue block13;
                }
                case 19: {
                    this.block13(data, is);
                    continue block13;
                }
                case 20: {
                    this.block14(data, is);
                    continue block13;
                }
                case 32: {
                    int n = this.getWord(is);
                    if (n == 0) {
                        n = 5000;
                    }
                    this.block(data, is, n, 0, 0, 0, 0, 0, 0, 0, 0);
                    continue block13;
                }
                case 33: {
                    int n = is.read();
                    byte[] buffer = new byte[n];
                    if (is.read(buffer) != n) {
                        return null;
                    }
                    log.info("Group start :" + new String(buffer, 0, n));
                    continue block13;
                }
                case 34: {
                    log.info("Group end");
                    continue block13;
                }
                case 36: {
                    int n = this.getWord(is);
                    log.info("Loop start " + n);
                    continue block13;
                }
                case 37: {
                    log.info("Loop end");
                    continue block13;
                }
                case 48: {
                    int n = is.read();
                    byte[] buffer = new byte[n];
                    if (is.read(buffer) != n) {
                        return null;
                    }
                    log.info("Description :" + new String(buffer, 0, n));
                    continue block13;
                }
                case 50: {
                    int n = this.getWord(is);
                    this.skip(is, n);
                    continue block13;
                }
            }
            log.warning("Unknow block " + id);
            return null;
        }
        return data;
    }

    private void block10(TapeData data, InputStream is) throws IOException {
        int pause = this.getWord(is);
        int len = this.getWord(is);
        is.mark(128);
        int v = is.read();
        is.reset();
        int pilot_length = v == 0 ? 8084 : 3220;
        this.block(data, is, pause, len, 2168, pilot_length, 667, 735, 855, 1710, 8);
    }

    private void block14(TapeData data, InputStream is) throws IOException {
        int bit0 = this.getWord(is);
        int bit1 = this.getWord(is);
        int last = is.read();
        int pause = this.getWord(is);
        int len = this.get3byte(is);
        this.block(data, is, pause, len, 0, 0, 0, 0, bit0, bit1, last);
    }

    private void block13(TapeData data, InputStream is) throws IOException {
        int n = is.read();
        for (int i = 0; i < n; ++i) {
            int p = this.getWord(is);
            data.add(new TapePulse(p));
        }
    }

    private void block12(TapeData data, InputStream is) throws IOException {
        int pilot = this.getWord(is);
        int pilotLen = this.getWord(is);
        this.block(data, is, 0, 0, pilot, pilotLen, 0, 0, 0, 0, 0);
    }

    void block(TapeData data, InputStream is, int pause, int len, int pilot, int pilotLen, int sync1, int sync2, int bit0, int bit1, int bitlast) throws IOException {
        TapePulse pulsePilot = new TapePulse(pilot);
        TapePulse pulse0 = new TapePulse(bit0);
        TapePulse pulse1 = new TapePulse(bit1);
        log.info("Block Pause=" + pause + " Pilot=" + pilot + " sync1=" + sync1 + " sync2=" + sync2 + " len=" + len);
        while (pilotLen-- > 0) {
            data.add(pulsePilot);
        }
        if (sync1 > 0) {
            data.add(new TapePulse(sync1));
        }
        if (sync2 > 0) {
            data.add(new TapePulse(sync2));
        }
        while (len-- > 0) {
            int v = is.read();
            int nbit = len == 0 ? bitlast : 8;
            for (int i = 0; i < nbit; ++i) {
                if ((v & 0x80) != 0) {
                    data.add(pulse1);
                    data.add(pulse1);
                } else {
                    data.add(pulse0);
                    data.add(pulse0);
                }
                v <<= 1;
            }
        }
        if (pause > 0) {
            data.add(new TapePulse(1, 3500));
            data.add(new TapePulse(0, (pause - 1) * 3500));
        }
    }

    public String toString() {
        return "TZX 1.00";
    }
}

