/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.terminal;

import jmce.sim.SIMException;
import jmce.sim.terminal.SampleTerminal;

public class Hazeltine1500
extends SampleTerminal {
    private int state = 0;
    private int setRow;
    private int setCol;

    public Hazeltine1500() {
        super("Hazeltine1500");
        this.setNumRow(25);
        this.setNumCol(80);
        this.setNumStatus(1);
    }

    private void leadin(int c) {
        switch (c) {
            case 18: {
                this.home();
                break;
            }
            case 12: {
                if (this.getRow() <= 0) break;
                this.setCursor(this.getRow() - 1, this.getCol());
                break;
            }
            case 11: {
                if (this.getRow() >= this.getNumRow() - 1) break;
                this.setCursor(this.getRow() + 1, this.getCol());
                break;
            }
            case 17: {
                ++this.state;
                return;
            }
            case 28: {
                this.cls();
                this.home();
                break;
            }
            case 29: {
                this.cls();
                break;
            }
            case 15: {
                this.clearEol();
                break;
            }
            case 23: {
                this.clearEos();
                break;
            }
            case 24: {
                this.clearEos();
                break;
            }
            case 25: {
                this.setAtt(0);
                break;
            }
            case 31: {
                this.setAtt(2);
                break;
            }
            case 19: {
                this.deleteLine();
                this.setCursor(this.getRow(), 0);
                break;
            }
            case 26: {
                this.insertLine();
                this.setCursor(this.getRow(), 0);
            }
        }
        this.state = 0;
    }

    @Override
    public void putchar(int c) throws SIMException {
        block0 : switch (this.state) {
            case 0: {
                switch (c) {
                    case 126: {
                        this.state = 1;
                        break block0;
                    }
                    case 16: {
                        this.right();
                        break block0;
                    }
                }
                super.putchar(c);
                return;
            }
            case 1: {
                this.leadin(c);
                break;
            }
            case 2: {
                this.setCol = c;
                this.setCol %= 96;
                ++this.state;
                break;
            }
            case 3: {
                this.setRow = c;
                this.setRow &= 0x1F;
                this.state = 0;
                if (this.setCol < 0) {
                    this.setCol = 0;
                }
                if (this.setCol >= this.getNumCol()) {
                    this.setCol = this.getNumCol() - 1;
                }
                if (this.setRow < 0) {
                    this.setRow = 0;
                }
                if (this.setRow >= this.getNumRow()) {
                    this.setRow = this.getNumRow() - 1;
                }
                this.setCursor(this.setRow, this.setCol);
            }
        }
    }
}

