/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.terminal;

import jmce.sim.terminal.SampleTerminal;
import jmce.util.Hex;

class TestTerminal {
    TestTerminal() {
    }

    public static void testTitle(SampleTerminal t, String s) throws Exception {
        t.cls();
        t.home();
        t.println("\n\t\t" + s);
        t.printStatusLine(0, s);
    }

    static void testContinue(SampleTerminal t) throws Exception {
        t.print("\nPress any key to continue");
        t.readOutput();
    }

    static void testCursor(SampleTerminal t) throws Exception {
        TestTerminal.testTitle(t, "Test cursor");
        for (int i = 0; i < 10; ++i) {
            t.setCursor(i + 5, i);
            t.print("Row=" + (i + 5) + ", Column=" + i);
        }
        t.println();
        TestTerminal.testContinue(t);
    }

    static void testValue(SampleTerminal t, String s1, String s2) throws Exception {
        while (s1.length() < 32) {
            s1 = " " + s1;
        }
        t.print(s1 + " : ");
        t.setAtt(2);
        t.println(s2);
        t.setAtt(0);
    }

    static void testValue(SampleTerminal t, String s1, int n) throws Exception {
        TestTerminal.testValue(t, s1, "" + n);
    }

    static void testInfo(SampleTerminal t) throws Exception {
        TestTerminal.testTitle(t, "Terminal info");
        TestTerminal.testValue(t, "Terminal name", t.getName());
        TestTerminal.testValue(t, "Number of rows", t.getNumRow());
        TestTerminal.testValue(t, "Number of status row", t.getNumStatus());
        TestTerminal.testValue(t, "Number of columns", t.getNumCol());
        TestTerminal.testValue(t, "Font ", t.getFont().toString());
        TestTerminal.testContinue(t);
    }

    static void testAttribute(SampleTerminal t) throws Exception {
        TestTerminal.testTitle(t, "Test attribute");
        for (int i = 0; i < 16; ++i) {
            t.setAtt(0);
            t.print("Atribute " + Hex.formatByte(i) + " ");
            t.setAtt(i);
            if (i == 0) {
                t.print("NORMAL");
            } else {
                if ((i & 1) != 0) {
                    t.print("REVERSE ");
                }
                if ((i & 2) != 0) {
                    t.print("HIGHLIGHT ");
                }
                if ((i & 4) != 0) {
                    t.print("UNDERLINE ");
                }
                if ((i & 8) != 0) {
                    t.print("BLINK ");
                }
            }
            t.println();
        }
        t.setAtt(0);
        TestTerminal.testContinue(t);
    }

    public static void test(SampleTerminal t) throws Exception {
        while (true) {
            t.cls();
            t.home();
            t.setAtt(0);
            t.printStatusLine(0, t.toString());
            t.println("\n\tTerminal test\n\n");
            t.println("1. Terminal information");
            t.println("2. Test attribute");
            t.println("3. Test cursor");
            t.println("0. Perform all test\n");
            t.print("\t\tChoice (ESC Stop) :");
            int c = (Integer)t.readOutput();
            if (c == 27) break;
            switch (c) {
                case 49: {
                    TestTerminal.testInfo(t);
                    break;
                }
                case 50: {
                    TestTerminal.testAttribute(t);
                    break;
                }
                case 51: {
                    TestTerminal.testCursor(t);
                    break;
                }
                case 48: {
                    TestTerminal.testInfo(t);
                    TestTerminal.testAttribute(t);
                    TestTerminal.testCursor(t);
                }
            }
        }
    }
}

