/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.terminal;

import jmce.sim.SIMException;
import jmce.sim.terminal.SampleTerminal;
import jmce.util.Logger;

public class VT100
extends SampleTerminal {
    private static Logger log = Logger.getLogger(VT100.class);
    int argc = 0;
    int[] argv = new int[16];
    State state = State.NORMAL;
    private int savedLocateRow;

    public VT100() {
        super("VT100");
        this.setNumRow(25);
        this.setNumCol(80);
    }

    private void putcharCSI(int c) {
        int i;
        this.state = State.NORMAL;
        StringBuffer sb = new StringBuffer();
        sb.append("CSI " + (char)c);
        for (i = 0; i <= this.argc; ++i) {
            sb.append(" ARGC#" + i + "=" + this.argv[i]);
        }
        log.fine(sb.toString());
        switch (c) {
            default: {
                log.info("Unsupported CSI " + (char)c);
                break;
            }
            case 109: {
                block22: for (i = 0; i <= this.argc; ++i) {
                    switch (this.argv[i]) {
                        case 7: {
                            this.setAtt(this.getAtt() | 1);
                            continue block22;
                        }
                        case 1: {
                            this.setAtt(this.getAtt() | 2);
                            continue block22;
                        }
                        case 0: {
                            this.setAtt(0);
                        }
                    }
                }
                break;
            }
            case 77: {
                this.deleteLine();
                break;
            }
            case 76: {
                this.insertLine();
                break;
            }
            case 75: {
                switch (this.argv[0]) {
                    case 0: {
                        this.clearEol();
                    }
                }
                break;
            }
            case 74: {
                switch (this.argv[0]) {
                    case 0: {
                        this.clearEos();
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.cls();
                        this.setCursor(0, 0);
                    }
                }
                break;
            }
            case 72: 
            case 102: {
                this.setCursor(this.argv[0] - 1, this.argv[1] - 1);
            }
        }
    }

    private void putcharArgs(int c) {
        if (c >= 48 && c <= 57) {
            this.argv[this.argc] = this.argv[this.argc] * 10 + (c - 48);
        } else if (c == 59) {
            ++this.argc;
            this.argv[this.argc] = 0;
        } else {
            this.putcharCSI(c);
        }
    }

    private void putcharEscape(int c) throws SIMException {
        if (c == 91) {
            this.state = State.ARGS;
            this.argc = 0;
            this.argv[0] = 0;
        } else if (c == 42) {
            this.state = State.LOCATE_ROW;
        } else {
            super.putchar(27);
            super.putchar(c);
            this.state = State.NORMAL;
        }
    }

    @Override
    public void putchar(int c) throws SIMException {
        switch (this.state) {
            case LOCATE_COL: {
                this.setCursor(this.savedLocateRow - 1, c - 1);
                this.state = State.NORMAL;
                break;
            }
            case LOCATE_ROW: {
                this.savedLocateRow = c;
                this.state = State.LOCATE_COL;
                break;
            }
            case NORMAL: {
                if (c == 27) {
                    this.state = State.ESCAPE;
                    break;
                }
                super.putchar(c);
                break;
            }
            case ESCAPE: {
                this.putcharEscape(c);
                break;
            }
            case ARGS: {
                this.putcharArgs(c);
            }
        }
    }

    private static enum State {
        NORMAL,
        ESCAPE,
        ARGS,
        LOCATE_ROW,
        LOCATE_COL;

    }
}

