/*
 * Decompiled with CFR 0.152.
 */
package jmce.sinclair.spectrum;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.Timer;
import jmce.sim.Memory;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.sinclair.spectrum.SpectrumConstants;
import jmce.util.Logger;
import jmce.util.RingBuffer;

public class ScreenPanel
extends JComponent
implements SpectrumConstants,
ActionListener,
MemoryWriteListener {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(ScreenPanel.class);
    private static final int screenWidth = 256;
    private static final int screenHeight = 192;
    private static final int topBorder = 24;
    private static final int bottomBorder = 24;
    private static final int leftBorder = 24;
    private static final int rightBorder = 24;
    private int pixelScale = 2;
    public static final int COLOR = 191;
    public static final int COLORBRIGHT = 255;
    private Dimension size = null;
    private Image image = null;
    private HashMap<Integer, Image> patterns = new HashMap();
    private static Color[] colors = new Color[16];
    private RingBuffer<Integer> memoryChanged = new RingBuffer(24576);
    private Color colorBorder = new Color(0, 0, 0);
    private Color oldBorder = new Color(0, 0, 0);
    private boolean flash = false;
    private Memory m;

    public ScreenPanel() {
        Timer timer = new Timer(20, this);
        timer.setRepeats(true);
        timer.start();
        this.size = new Dimension(304 * this.pixelScale, 240 * this.pixelScale);
        this.setPreferredSize(this.size);
    }

    public void setBorder(int border) {
        this.colorBorder = colors[border];
    }

    private Image getImage(JComponent comp, int pixel, int color) {
        int hashValue;
        Integer keyImage;
        Image img;
        if (this.flash & (color & 0xFFFFFF80) != 0) {
            int c1 = color & 7;
            int c2 = color >> 3 & 7;
            color &= 0xC0;
            color |= c1 << 3 | c2;
        }
        if ((img = this.patterns.get(keyImage = new Integer(hashValue = pixel << 8 | (color &= 0x7F)))) == null) {
            int base = 0;
            if ((color & 0x40) != 0) {
                base = 8;
            }
            Color bg = colors[base + (color >> 3 & 7)];
            Color fg = colors[base + (color & 7)];
            img = comp.createImage(8 * this.pixelScale, 1 * this.pixelScale);
            Graphics g = img.getGraphics();
            for (int c = 0; c < 8; ++c) {
                Color clr = bg;
                if ((pixel & 128 >> c) != 0) {
                    clr = fg;
                }
                g.setColor(clr);
                g.fillRect(c * this.pixelScale, 0, this.pixelScale, 1 * this.pixelScale);
            }
            this.patterns.put(keyImage, img);
        }
        return img;
    }

    @Override
    public void writeMemory(Memory m, int add, int value, int oldValue) throws SIMException {
        if (add >= 0 && add <= 6143) {
            this.repaintScreen(add - 0);
        } else if (add >= 6144 && add <= 6911) {
            this.repaintAttribute(add - 6144);
        }
    }

    public void setMemory(Memory m) {
        this.m = m;
        m.removeMemoryWriteListener(this);
        m.addMemoryWriteListener(this);
        for (int i = 0; i < 6144; ++i) {
            this.repaintScreen(i);
        }
    }

    private int getMemory(int offset) {
        try {
            return this.m.getMemory(offset);
        }
        catch (Exception e) {
            log.warning(e);
            return 255;
        }
    }

    private void drawByte(int addr, Graphics g) {
        int pixel = this.getMemory(addr);
        int x = (addr & 0x1F) << 3;
        int y = ((addr & 0xE0) >> 2) + ((addr & 0x700) >> 8) + ((addr & 0x1800) >> 5);
        int X = (x + 24) * this.pixelScale;
        int Y = (y + 24) * this.pixelScale;
        int attr = this.getMemory(6144 + (addr & 0x1F) + (y >> 3) * 32) & 0xFF;
        Image chars = this.getImage(this, pixel, attr);
        g.drawImage(chars, X, Y, null);
    }

    private void drawScreen() {
        Graphics g = this.image.getGraphics();
        if (this.colorBorder != this.oldBorder) {
            this.oldBorder = this.colorBorder;
            g.setColor(this.colorBorder);
            g.fillRect(0, 0, 24 * this.pixelScale, this.size.height);
            g.fillRect(0, 0, this.size.width, this.pixelScale * 24);
            g.fillRect(this.size.width - 24 * this.pixelScale, 0, 24 * this.pixelScale, this.size.height);
            g.fillRect(0, this.size.height - 24 * this.pixelScale, this.size.width, this.pixelScale * 24);
        }
        Integer n = this.memoryChanged.get();
        while (n != null) {
            this.drawByte(n, g);
            n = this.memoryChanged.get();
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.image == null) {
            this.image = this.createImage(this.size.width, this.size.height);
        }
        this.drawScreen();
        g.drawImage(this.image, 0, 0, this);
    }

    public void updateBlink() {
        this.flash = !this.flash;
        for (int i = 0; i < 768; ++i) {
            if ((this.getMemory(i + 6144) & 0xFFFFFF80) == 0) continue;
            this.repaintAttribute(i);
        }
    }

    void repaintAttribute(int addr) {
        int scrAddr = (addr & 0x300) << 3 | addr & 0xFF;
        for (int i = 0; i < 8; ++i) {
            this.repaintScreen(scrAddr);
            scrAddr += 256;
        }
    }

    void repaintScreen(int add) {
        this.memoryChanged.put(add);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.memoryChanged.getSize() > 0 || this.colorBorder != this.oldBorder) {
            this.repaint();
        }
    }

    void setScale(int scale) {
        this.pixelScale = scale;
    }

    @Override
    public String toString() {
        return "Spectrum Screen";
    }

    static {
        ScreenPanel.colors[0] = new Color(0, 0, 0);
        ScreenPanel.colors[1] = new Color(0, 0, 191);
        ScreenPanel.colors[2] = new Color(191, 0, 0);
        ScreenPanel.colors[3] = new Color(191, 0, 191);
        ScreenPanel.colors[4] = new Color(0, 191, 0);
        ScreenPanel.colors[5] = new Color(0, 191, 191);
        ScreenPanel.colors[6] = new Color(191, 191, 0);
        ScreenPanel.colors[7] = new Color(191, 191, 191);
        for (int i = 0; i < 8; ++i) {
            ScreenPanel.colors[8 + i] = new Color(colors[i].getRed() != 0 ? 255 : 0, colors[i].getGreen() != 0 ? 255 : 0, colors[i].getBlue() != 0 ? 255 : 0);
        }
    }
}

