/*
 * Decompiled with CFR 0.152.
 */
package jmce.sinclair.spectrum;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import jmce.sim.CPU;
import jmce.sim.LoadInfo;
import jmce.sim.Memory;
import jmce.sim.SIMException;
import jmce.sim.SIMIOException;
import jmce.sim.cpu.AbstractLoader;
import jmce.sinclair.spectrum.Spectrum;
import jmce.util.Hex;
import jmce.util.Logger;

public class ZXSnapshot
extends AbstractLoader {
    private static Logger log = Logger.getLogger(ZXSnapshot.class);
    public static final int RAM_MEMORY_START = 16384;
    protected Spectrum cpu;

    public ZXSnapshot() {
        super("z80");
    }

    @Override
    public void setCPU(CPU cpu) {
        super.setCPU(cpu);
        this.cpu = (Spectrum)cpu;
    }

    @Override
    public void load(Memory m, String name, int address, LoadInfo info) throws SIMException {
        File file = new File(name);
        int snapshotLength = (int)file.length();
        info.start = 16384;
        info.end = snapshotLength + info.start;
        log.info("ZXSnapshot " + name + " lenght=" + snapshotLength);
        try {
            FileInputStream is = new FileInputStream(file);
            if (snapshotLength == 49179) {
                this.loadSNA(this.cpu, name, is);
            } else {
                this.loadZ80(name, is, snapshotLength);
            }
            is.close();
        }
        catch (IOException e) {
            throw new SIMIOException(name, e.toString());
        }
    }

    public int readBytes(InputStream is, int[] mem, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int c = is.read();
            if (c < 0) {
                return i;
            }
            mem[i] = c & 0xFF;
        }
        return len;
    }

    public void loadSNA(Spectrum cpu, String name, InputStream is) throws IOException, SIMException {
        log.info("loadSNA " + name);
        int[] header = new int[27];
        this.readBytes(is, header, 27);
        for (int i = 0; i < 49152; ++i) {
            cpu.setByte(16384 + i, is.read());
        }
        cpu.I = header[0];
        cpu.HL = header[1] | header[2] << 8;
        cpu.DE = header[3] | header[4] << 8;
        cpu.BC = header[5] | header[6] << 8;
        cpu.A = header[7];
        cpu.F = header[8];
        cpu.exx();
        cpu.ex_af_af1();
        cpu.HL = header[9] | header[10] << 8;
        cpu.DE = header[11] | header[12] << 8;
        cpu.BC = header[13] | header[14] << 8;
        cpu.IY = header[15] | header[16] << 8;
        cpu.IX = header[17] | header[18] << 8;
        cpu.iff2 = (header[19] & 4) != 0;
        cpu.R = header[20];
        cpu.A = header[21];
        cpu.F = header[22];
        cpu.SP = header[23] | header[24] << 8;
        switch (header[25]) {
            case 0: {
                cpu.im(0);
                break;
            }
            case 1: {
                cpu.im(1);
                break;
            }
            default: {
                cpu.im(2);
            }
        }
        cpu.out(254, header[26], 0);
        cpu.iff1 = cpu.iff2;
        cpu.PC = cpu.pop();
    }

    public void loadZ80(String name, InputStream is, int bytesLeft) throws SIMException, IOException {
        log.info("LoadZ80 " + name);
        int[] header = new int[30];
        boolean compressed = false;
        bytesLeft -= this.readBytes(is, header, 30);
        this.cpu.A = header[0];
        this.cpu.F = header[1];
        this.cpu.BC = header[2] | header[3] << 8;
        this.cpu.HL = header[4] | header[5] << 8;
        this.cpu.PC = header[6] | header[7] << 8;
        this.cpu.SP = header[8] | header[9] << 8;
        this.cpu.I = header[10];
        this.cpu.R = header[11];
        int tbyte = header[12];
        if (tbyte == 255) {
            tbyte = 1;
        }
        this.cpu.out(254, tbyte >> 1 & 7, 0);
        if ((tbyte & 1) != 0) {
            this.cpu.R |= 0x80;
        }
        compressed = (tbyte & 0x20) != 0;
        this.cpu.DE = header[13] | header[14] << 8;
        this.cpu.ex_af_af1();
        this.cpu.exx();
        this.cpu.BC = header[15] | header[16] << 8;
        this.cpu.DE = header[17] | header[18] << 8;
        this.cpu.HL = header[19] | header[20] << 8;
        this.cpu.A = header[21];
        this.cpu.F = header[22];
        this.cpu.ex_af_af1();
        this.cpu.exx();
        this.cpu.IY = header[23] | header[24] << 8;
        this.cpu.IX = header[25] | header[26] << 8;
        this.cpu.iff1 = header[27] != 0;
        this.cpu.iff2 = header[28] != 0;
        switch (header[29] & 3) {
            case 0: {
                this.cpu.im(0);
                break;
            }
            case 1: {
                this.cpu.im(1);
                break;
            }
            default: {
                this.cpu.im(2);
            }
        }
        if (this.cpu.PC == 0) {
            this.loadZ80_extended(is, bytesLeft);
            return;
        }
        if (compressed) {
            int[] data = new int[bytesLeft];
            int addr = 16384;
            int size = this.readBytes(is, data, bytesLeft);
            log.info("Byte " + size + " at " + Hex.formatWord(addr));
            int i = 0;
            while (addr < 65536 && i < size) {
                if ((tbyte = data[i++]) != 237) {
                    this.cpu.setByte(addr, tbyte);
                    ++addr;
                    continue;
                }
                if ((tbyte = data[i++]) != 237) {
                    this.cpu.setByte(addr, 237);
                    --i;
                    ++addr;
                    continue;
                }
                int count = data[i++];
                tbyte = data[i++];
                while (count-- != 0) {
                    this.cpu.setByte(addr, tbyte);
                    ++addr;
                }
            }
        } else {
            for (int i = 0; i < 49152; ++i) {
                this.cpu.setByte(16384 + i, is.read());
            }
        }
    }

    private void loadZ80_extended(InputStream is, int bytesLeft) throws SIMException, IOException {
        int[] header = new int[2];
        bytesLeft -= this.readBytes(is, header, header.length);
        log.info("LoadZ80_extended");
        int type = header[0] | header[1] << 8;
        switch (type) {
            case 23: {
                this.loadZ80_v201(this.cpu, is, bytesLeft);
                break;
            }
            case 54: {
                this.loadZ80_v300(this.cpu, is, bytesLeft);
                break;
            }
            case 58: {
                this.loadZ80_v301(this.cpu, is, bytesLeft);
                break;
            }
            default: {
                throw new SIMException("Z80 (extended): unsupported type " + type);
            }
        }
    }

    private void loadZ80_v201(Spectrum cpu, InputStream is, int bytesLeft) throws SIMException, IOException {
        int[] header = new int[23];
        cpu.PC = header[0] | header[1] << 8;
        int type = header[2];
        int[] data = new int[bytesLeft -= this.readBytes(is, header, header.length)];
        this.readBytes(is, data, bytesLeft);
        int offset = 0;
        for (int j = 0; j < 3; ++j) {
            offset = this.loadZ80_page(data, offset, type);
        }
    }

    private void loadZ80_v300(Spectrum cpu, InputStream is, int bytesLeft) throws SIMException, IOException {
        int[] header = new int[54];
        bytesLeft -= this.readBytes(is, header, header.length);
        cpu.PC = header[0] | header[1] << 8;
        int type = header[2];
        if (type > 6) {
            throw new SIMException("Z80 (v300): unsupported type " + type);
        }
        int[] data = new int[bytesLeft];
        this.readBytes(is, data, bytesLeft);
        int offset = 0;
        for (int j = 0; j < 3; ++j) {
            offset = this.loadZ80_page(data, offset, type);
        }
    }

    private void loadZ80_v301(Spectrum cpu, InputStream is, int bytesLeft) throws SIMException, IOException {
        int[] header = new int[58];
        bytesLeft -= this.readBytes(is, header, header.length);
        cpu.PC = header[0] | header[1] << 8;
        int type = header[2];
        if (type > 7) {
            throw new SIMException("Z80 (v301): unsupported type " + type);
        }
        int[] data = new int[bytesLeft];
        this.readBytes(is, data, bytesLeft);
        int offset = 0;
        for (int j = 0; j < 3; ++j) {
            offset = this.loadZ80_page(data, offset, type);
        }
    }

    private int page2address(int type, int page) throws SIMException {
        int addr = -1;
        if (type == 0) {
            switch (page) {
                case 4: {
                    addr = 32768;
                    break;
                }
                case 5: {
                    addr = 49152;
                    break;
                }
                case 8: {
                    addr = 16384;
                }
            }
        } else if (type == 4 && page >= 3 && page <= 10) {
            addr = 49152;
            this.cpu.out(253, page - 3, 127);
        }
        if (addr == -1) {
            throw new SIMException("z80 page " + page + " type " + type + " unsupported");
        }
        log.info("z80 page " + page + " type " + type + " at " + Integer.toHexString(addr));
        return addr;
    }

    private int loadZ80_page(int[] data, int i, int type) throws SIMException {
        int blocklen = data[i++];
        blocklen |= data[i++] << 8;
        int page = data[i++];
        int addr = this.page2address(type, page);
        int k = 0;
        while (k < blocklen) {
            int tbyte = data[i++];
            ++k;
            if (tbyte != 237) {
                this.cpu.setByte(addr, ~tbyte);
                this.cpu.setByte(addr, tbyte);
                ++addr;
                continue;
            }
            tbyte = data[i++];
            ++k;
            if (tbyte != 237) {
                this.cpu.setByte(addr, 0);
                this.cpu.setByte(addr, 237);
                ++addr;
                --i;
                --k;
                continue;
            }
            int count = data[i++];
            ++k;
            tbyte = data[i++];
            ++k;
            while (count-- > 0) {
                this.cpu.setByte(addr, ~tbyte);
                this.cpu.setByte(addr, tbyte);
                ++addr;
            }
        }
        if ((addr & 0x3FFF) != 0) {
            throw new SIMException("Z80 (page): overrun");
        }
        return i;
    }
}

