/*
 * Decompiled with CFR 0.152.
 */
package jmce.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmce.swing.Repaintable;
import jmce.swing.Util;

public class KBitField
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private KBit[] bits = new KBit[8];
    private Vector<ActionListener> listeners = new Vector();
    private int value;

    public KBitField(String title) {
        this(title, true);
    }

    public KBitField(String title, boolean bit) {
        super(new GridBagLayout());
        GridBagConstraints g = new GridBagConstraints();
        g.gridx = 0;
        g.gridy = 0;
        g.gridwidth = 1;
        g.gridheight = 1;
        g.anchor = 10;
        g.fill = 0;
        g.insets = new Insets(0, 0, 0, 0);
        for (int i = 0; i < this.bits.length; ++i) {
            String label = "" + (7 - i);
            g.gridy = 0;
            if (bit) {
                JLabel l = new JLabel(label);
                l.setFont(Util.fontLabel);
                this.add((Component)l, g);
                g.gridy = 1;
            }
            this.bits[7 - i] = new KBit();
            this.bits[7 - i].setMargin(new Insets(0, 0, 0, 0));
            this.bits[7 - i].addActionListener(this);
            this.bits[7 - i].setToolTipText(label);
            this.add((Component)this.bits[7 - i], g);
            ++g.gridx;
        }
        Util.setTitle(this, title);
        this.setValue(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ActionListener l = this.listeners.elementAt(i);
            l.actionPerformed(e);
        }
    }

    public void setBitName(int bit, String name) {
        this.bits[bit].setToolTipText(name);
    }

    public void setDisabled(int bit, boolean mode) {
        this.bits[bit].setEnabled(!mode);
    }

    public void setValue(int value) {
        if (value == this.value) {
            return;
        }
        this.value = value;
        for (int i = 0; i < this.bits.length; ++i) {
            boolean newBit = (value & 1 << i) != 0;
            this.bits[i].set(newBit);
        }
    }

    public int getValue() {
        int value = 0;
        for (int i = 0; i < this.bits.length; ++i) {
            if (!this.bits[i].isSelected()) continue;
            value |= 1 << i;
        }
        return value;
    }

    public void setEditable(boolean mode) {
        for (int i = 0; i < this.bits.length; ++i) {
            this.bits[i].setEnabled(mode);
        }
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    class KBit
    extends JCheckBox
    implements Repaintable {
        private static final long serialVersionUID = 1L;
        boolean value;

        KBit() {
        }

        public void set(boolean value) {
            if (this.value == value) {
                return;
            }
            this.value = value;
            if (value != this.isSelected()) {
                Util.repaintLater(this);
            }
        }

        @Override
        public void updateComponent() {
            this.setSelected(this.value);
        }
    }
}

