/*
 * Decompiled with CFR 0.152.
 */
package jmce.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class KMatrixKeyboard
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int numRows = 0;
    private int numCols = 0;
    private AbstractButton[][] keysButton;
    private JComponent[][] keysComponent;
    private String[][] keysString;
    private int[][] keys;

    public KMatrixKeyboard() {
        super(new GridBagLayout());
        this.setNumRows(4);
        this.setNumCols(4);
        this.setKey(0, 0, '1');
        this.setKey(0, 1, '2');
        this.setKey(0, 2, '3');
        this.setKey(0, 3, 'A');
        this.setKey(1, 0, '4');
        this.setKey(1, 1, '5');
        this.setKey(1, 2, '6');
        this.setKey(1, 3, 'B');
        this.setKey(2, 0, '7');
        this.setKey(2, 1, '8');
        this.setKey(2, 2, '9');
        this.setKey(2, 3, 'C');
        this.setKey(3, 0, '*');
        this.setKey(3, 1, '0');
        this.setKey(3, 2, '#');
        this.setKey(3, 3, 'D');
    }

    public void setComponent(int r, int c, JComponent j) {
        GridBagConstraints g = new GridBagConstraints();
        g.gridx = c;
        g.gridy = r;
        this.add((Component)j, g);
        this.keysComponent[r][c] = j;
    }

    private void setKey(int r, int c, AbstractButton b) {
        this.keysButton[r][c] = b;
        b.setMnemonic(this.keys[r][c]);
        this.setComponent(r, c, b);
    }

    private void setKey(int r, int c, String s) {
        this.keysString[r][c] = s;
        this.setKey(r, c, new JButton(s));
    }

    public void setKey(int r, int c, char s) {
        this.keys[r][c] = s;
        this.setKey(r, c, "" + s);
    }

    public void setNumCols(int n) {
        if (n != this.numCols) {
            this.numCols = n;
            this.createArray();
        }
    }

    public void setNumRows(int n) {
        if (n != this.numRows) {
            this.numRows = n;
            this.createArray();
        }
    }

    private void createArray() {
        this.keysButton = new AbstractButton[this.numRows][this.numCols];
        this.keysComponent = new JComponent[this.numRows][this.numCols];
        this.keysString = new String[this.numRows][this.numCols];
        this.keys = new int[this.numRows][this.numCols];
        this.removeAll();
    }
}

