/*
 * Decompiled with CFR 0.152.
 */
package jmce.util;

import java.util.Arrays;

public class FastArray<E> {
    private int growSize;
    private Object[] objects;
    private int currentSize;

    public FastArray(int initialCapacity, int growSize) {
        this.objects = new Object[initialCapacity];
        this.currentSize = 0;
        this.growSize = growSize;
    }

    public FastArray(int n) {
        this(n, 10);
    }

    public FastArray() {
        this(0);
    }

    public final void setGrowSize(int n) {
        this.growSize = n;
    }

    public final int getGrowSize() {
        return this.growSize;
    }

    @Deprecated
    public final int size() {
        return this.currentSize;
    }

    public final int getSize() {
        return this.currentSize;
    }

    private final void checkSize() {
        if (this.currentSize >= this.objects.length) {
            int n = this.growSize == 0 ? this.objects.length : this.growSize;
            Object[] newObjects = new Object[this.objects.length + n];
            System.arraycopy(this.objects, 0, newObjects, 0, this.objects.length);
            this.objects = newObjects;
            Object var2_2 = null;
        }
    }

    public final void clear() {
        this.currentSize = 0;
    }

    public final void add(E o) {
        this.checkSize();
        this.objects[this.currentSize++] = o;
    }

    public final void add(int i, Object o) {
        this.checkSize();
        System.arraycopy(this.objects, i, this.objects, i + 1, this.currentSize - i);
        this.objects[i] = o;
        ++this.currentSize;
    }

    public final int indexOf(Object o) {
        for (int i = this.currentSize - 1; i >= 0; --i) {
            if (this.objects[i] != o) continue;
            return i;
        }
        return -1;
    }

    public final void remove(int i) {
        if (i < this.currentSize && i >= 0) {
            this.objects[i] = null;
            int num = this.currentSize - i - 1;
            if (num > 0) {
                System.arraycopy(this.objects, i + 1, this.objects, i, num);
            }
            --this.currentSize;
        }
    }

    public final void remove(Object o) {
        int i = this.indexOf(o);
        if (i != -1) {
            this.remove(i);
        }
    }

    public final E get(int i) {
        return (E)this.objects[i];
    }

    public final boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public final E[] toArray(E[] a) {
        return Arrays.copyOf(this.objects, this.currentSize, a.getClass());
    }
}

