/*
 * Decompiled with CFR 0.152.
 */
package jmce.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.LogManager;

public class Logger
extends java.util.logging.Logger {
    static LogManager logManager = null;
    public static String configuration = "logging.properties";

    public static Logger getLogger(Class clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name) {
        java.util.logging.Logger l;
        if (logManager == null) {
            try {
                logManager = LogManager.getLogManager();
                logManager.reset();
                FileInputStream is = new FileInputStream(configuration);
                logManager.readConfiguration(is);
                is.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if ((l = logManager.getLogger(name)) == null || !(l instanceof Logger)) {
            l = new Logger(name);
            logManager.addLogger(l);
        }
        return (Logger)l;
    }

    private void log(Level level, Exception ex) {
        if (this.isLoggable(level)) {
            Logger.writeEx(ex);
            StringBuffer sb = new StringBuffer();
            this.log(level, ex.toString());
            StackTraceElement[] st = ex.getStackTrace();
            for (int i = 0; i < st.length; ++i) {
                sb.append(st[i].toString());
                if (i == st.length - 1) continue;
                sb.append("\n");
            }
            this.log(level, sb.toString());
        }
    }

    public void fine(Exception ex) {
        this.log(Level.FINE, ex);
    }

    public void info(Exception ex) {
        this.log(Level.INFO, ex);
    }

    public void warning(Exception ex) {
        this.log(Level.WARNING, ex);
    }

    public void fatal(Exception ex) {
        this.log(Level.SEVERE, ex);
        System.exit(1);
    }

    private Logger(String name) {
        super(name, null);
    }

    public static void setConfiguration(String s) {
        configuration = s;
    }

    public static void writeEx(Throwable e) {
        System.err.println(e);
        try {
            FileOutputStream os = new FileOutputStream("ex.txt");
            e.printStackTrace(new PrintStream(os));
            os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

