/*
 * Decompiled with CFR 0.152.
 */
package jmce.util;

public class RingBuffer<E> {
    private Object[] buffer;
    private int pl;
    private int ps;

    public RingBuffer(int size) {
        this.buffer = new Object[size];
        this.ps = 0;
        this.pl = 0;
    }

    public RingBuffer() {
        this(256);
    }

    public final void purge() {
        this.pl = 0;
        this.ps = 0;
    }

    public final E peek() {
        if (this.ps == this.pl) {
            return null;
        }
        return (E)this.buffer[this.pl];
    }

    public final E get() {
        if (this.ps == this.pl) {
            return null;
        }
        Object o = this.buffer[this.pl];
        if (++this.pl >= this.buffer.length) {
            this.pl = 0;
        }
        return (E)o;
    }

    public final int count() {
        int count = 0;
        int newPl = this.pl;
        while (newPl != this.ps) {
            ++count;
            if (newPl++ <= this.buffer.length) continue;
            newPl = 0;
        }
        return count;
    }

    public final boolean put(E o) {
        int newPs = this.ps + 1;
        if (newPs >= this.buffer.length) {
            newPs = 0;
        }
        if (newPs == this.pl) {
            return false;
        }
        this.buffer[this.ps] = o;
        this.ps = newPs;
        return true;
    }

    public final boolean isEmpty() {
        return this.ps == this.pl;
    }

    public final boolean isFull() {
        int newPs = this.ps + 1;
        if (newPs > this.buffer.length) {
            newPs = 0;
        }
        return newPs == this.pl;
    }

    public final int getSize() {
        return this.buffer.length;
    }

    public final boolean contains(Object o) {
        int i = this.pl;
        while (i != this.ps) {
            if (this.buffer[i] == o) {
                return true;
            }
            if (++i < this.buffer.length) continue;
            i = 0;
        }
        return false;
    }
}

