/*
 * Decompiled with CFR 0.152.
 */
package jmce.viara.v8052;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import jmce.hitachi.HD44780;
import jmce.sim.AbstractPeripheral;
import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.sim.SwingHardware;

public class Display
extends AbstractPeripheral
implements SwingHardware {
    public static final int LCD_RW = 1;
    public static final int LCD_RS = 2;
    public static final int LCD_EN = 4;
    private JPanel p = null;
    private HD44780 lcd = new HD44780();
    private int p0;
    private int p1;

    public Display() {
        this.setName("Display 4x20");
        this.lcd.setNumRows(4);
        this.lcd.setNumColumns(20);
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        cpu.addIOWriteListener(128, new MemoryWriteListener(){

            @Override
            public void writeMemory(Memory memory, int address, int value, int oldValue) throws SIMException {
                Display.this.writeP0(memory, value);
            }
        });
        cpu.addIOWriteListener(144, new MemoryWriteListener(){

            @Override
            public void writeMemory(Memory memory, int address, int value, int oldValue) throws SIMException {
                Display.this.writeP1(memory, value);
            }
        });
        cpu.addIOReadListener(128, new MemoryReadListener(){

            @Override
            public int readMemory(Memory memory, int address, int value) throws SIMException {
                return Display.this.p0;
            }
        });
    }

    public void writeP0(Memory memory, int value) {
        this.p0 = value;
    }

    public void writeP1(Memory memory, int value) throws SIMException {
        this.p1 = value;
        if ((this.p1 & 4) != 0) {
            int address;
            int n = address = (this.p1 & 2) != 0 ? 1 : 0;
            if ((this.p1 & 1) == 0) {
                this.lcd.writeMemory(memory, address, this.p0, ~this.p0);
            } else {
                this.p0 = this.lcd.readMemory(memory, address, this.p0);
            }
        }
    }

    @Override
    public Component getComponent() {
        if (this.p == null) {
            this.p = new JPanel(new GridBagLayout());
            GridBagConstraints g = new GridBagConstraints();
            g.gridx = 0;
            g.gridy = 0;
            g.gridwidth = 1;
            g.gridheight = 1;
            g.anchor = 10;
            g.fill = 0;
            g.insets = new Insets(2, 2, 2, 2);
            this.p.add((Component)this.lcd, g);
            g.gridx = 0;
            ++g.gridy;
        }
        return this.p;
    }
}

