/*
 * Decompiled with CFR 0.152.
 */
package jmce.z80pack;

import jmce.sim.CPU;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.sim.memory.BankedMemory;
import jmce.z80pack.Z80PackConstants;

public class Memory
extends BankedMemory
implements Z80PackConstants,
MemoryReadListener,
MemoryWriteListener {
    public Memory() {
        this.setName("MEMORY");
        this.setSize(65536);
        this.setNumBank(16);
        this.setPageSize(256);
        this.setNumPage(256);
        this.setSharedStart(192);
        this.setSharedSize(64);
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        cpu.addIOWriteListener(20, this);
        cpu.addIOWriteListener(21, this);
        cpu.addIOWriteListener(22, this);
    }

    @Override
    public int readMemory(jmce.sim.Memory m, int address, int value) throws SIMException {
        switch (address) {
            case 20: {
                return this.isMmuInitialized() ? this.getNumBank() : 0;
            }
            case 21: {
                return this.getBank();
            }
            case 22: {
                return 256 - this.getSharedSize();
            }
        }
        return 0;
    }

    @Override
    public void writeMemory(jmce.sim.Memory m, int address, int value, int oldValue) throws SIMException {
        switch (address) {
            case 20: {
                if (this.isMmuInitialized()) break;
                this.setNumBank(value);
                this.initMmu();
                break;
            }
            case 21: {
                this.setBank(value);
                break;
            }
            case 22: {
                this.setSharedSize(256 - value);
                this.setSharedStart(value);
                break;
            }
        }
    }
}

