/*
 * Decompiled with CFR 0.152.
 */
package jmce;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import jmce.PanelDebug;
import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.sim.SIMException;
import jmce.util.Hex;
import jmce.util.StringUtil;

class PanelAssembly
extends PanelDebug {
    JScrollPane sc;
    private static final long serialVersionUID = 1L;
    private Memory memory = null;
    AbstractTableModel tm;
    JTable jt;
    private ArrayList<Boolean> breakPoint = new ArrayList();
    private ArrayList<Integer> pcs = new ArrayList();
    private boolean completed = false;

    PanelAssembly(CPU _cpu) {
        super("Assembler", _cpu);
        this.memory = this.cpu.getMemory();
        this.tm = new AbstractTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public int getRowCount() {
                return PanelAssembly.this.completed ? PanelAssembly.this.pcs.size() : PanelAssembly.this.pcs.size() + 1;
            }

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public Object getValueAt(int r, int c) {
                if (r >= PanelAssembly.this.pcs.size()) {
                    try {
                        PanelAssembly.this.decode(-1, r);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (r >= PanelAssembly.this.pcs.size()) {
                    return null;
                }
                int pc = PanelAssembly.this.pc(r);
                switch (c) {
                    case 0: {
                        return PanelAssembly.this.breakPoint.get(r);
                    }
                    case 1: {
                        return Hex.formatValue(pc, 4);
                    }
                    case 2: {
                        try {
                            String s = PanelAssembly.this.cpu.decodeAt(pc);
                            return StringUtil.expandTab(s);
                        }
                        catch (SIMException ex) {
                            return "??";
                        }
                    }
                }
                return null;
            }

            @Override
            public String getColumnName(int c) {
                switch (c) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return "Add";
                    }
                    case 2: {
                        return "Decode";
                    }
                }
                return null;
            }

            public Class getColumnClass(int c) {
                return this.getValueAt(0, c).getClass();
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 0;
            }

            @Override
            public void setValueAt(Object v, int r, int c) {
            }
        };
        this.jt = new JTable(this.tm);
        this.sc = new JScrollPane(this.jt);
        this.jt.setDefaultRenderer(String.class, new Renderer());
        this.sc.setVerticalScrollBarPolicy(22);
        this.sc.setHorizontalScrollBarPolicy(32);
        GridBagConstraints g = new GridBagConstraints();
        g.gridx = 0;
        g.gridy = 0;
        g.gridwidth = 1;
        g.gridheight = 1;
        g.fill = 1;
        g.insets = new Insets(1, 1, 1, 1);
        g.anchor = 10;
        this.add((Component)this.sc, g);
        this.createTable();
    }

    public void setPreferredHeight(int h) {
        Dimension d = this.sc.getPreferredSize();
        d.height = h;
        this.sc.setPreferredSize(d);
    }

    public void purge() {
        this.pcs.clear();
        this.breakPoint.clear();
    }

    private int pc(int r) {
        return this.pcs.get(r);
    }

    private void decode(int maxPc, int maxRow) throws SIMException {
        int pc;
        if (this.pcs.size() == 0) {
            pc = 0;
        } else {
            pc = this.pc(this.pcs.size() - 1);
            pc += this.cpu.getLenghtAt(pc);
        }
        int from = this.pcs.size();
        while (true) {
            if (pc >= this.memory.getSize()) {
                this.completed = true;
                break;
            }
            if (maxRow >= 0 && this.pcs.size() > maxRow || maxPc >= 0 && pc > maxPc) break;
            this.pcs.add(new Integer(pc));
            this.breakPoint.add(new Boolean(false));
            pc += this.cpu.getLenghtAt(pc);
            this.tm.fireTableRowsInserted(this.pcs.size() - 1, this.pcs.size() - 1);
        }
    }

    private void createTable() {
        this.pcs.clear();
        this.breakPoint.clear();
        this.completed = false;
        for (int i = 0; i < this.tm.getColumnCount(); ++i) {
            JComponent comp;
            TableColumn c = this.jt.getColumnModel().getColumn(i);
            switch (i) {
                default: {
                    comp = new JTextField(50);
                    break;
                }
                case 1: {
                    comp = new JTextField(4);
                    break;
                }
                case 0: {
                    comp = new JCheckBox();
                }
            }
            Dimension dim = ((Component)comp).getPreferredSize();
            c.setPreferredWidth(dim.width);
            c.setResizable(false);
        }
        this.tm.fireTableDataChanged();
    }

    @Override
    public void update(CPU cpu) throws SIMException {
        int row = 0;
        this.decode(cpu.pc(), -1);
        for (int i = 0; i < this.pcs.size(); ++i) {
            if (this.pc(i) < cpu.pc()) continue;
            row = i;
            break;
        }
        Rectangle rect = this.jt.getCellRect(row, 0, true);
        this.jt.scrollRectToVisible(rect);
        this.jt.clearSelection();
        this.jt.setRowSelectionInterval(row, row);
    }

    @Override
    public void setEmulation(boolean mode) {
        this.jt.setEnabled(!mode);
    }

    class Renderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        Renderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setMonospacedFont();
            return this;
        }

        private void setMonospacedFont() {
            Font font = this.getFont();
            font = new Font("Monospaced", font.getStyle(), font.getSize());
            this.setFont(font);
        }
    }
}

