/*
 * Decompiled with CFR 0.152.
 */
package jmce;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import jmce.PanelDebug;
import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.swing.KFixedField;
import jmce.swing.KLongField;

class PanelInfo
extends PanelDebug
implements ActionListener {
    private static final long serialVersionUID = 1L;
    KFixedField name;
    KLongField clock;
    KLongField clockPerCycle;
    KLongField cycle;
    JCheckBox realtime;
    KFixedField usage;
    KLongField memory;

    PanelInfo(CPU info) {
        super("Information", info);
        this.name = new KFixedField(this.cpu.getName());
        this.memory = new KLongField();
        this.cycle = new KLongField();
        this.realtime = new JCheckBox();
        this.realtime.addActionListener(this);
        this.clockPerCycle = new KLongField(3);
        this.clock = new KLongField();
        this.usage = new KFixedField(10);
        this.usage.setHorizontalAlignment(4);
        this.add("Cpu name", this.name);
        this.add("Oscillator", this.clock);
        this.add("Clock per cycle", this.clockPerCycle);
        this.add("Realtime mode", this.realtime);
        this.add("Current cycle", this.cycle);
        this.add("Virtual machine usage", this.usage);
        this.add("Memory usage", this.memory);
        for (int i = 0; i < this.cpu.getMemoryCount(); ++i) {
            Memory m = this.cpu.getMemoryAt(i);
            KFixedField f = new KFixedField(m.getName());
            f.setToolTipText(m.toString());
            this.add("Memory #" + i, f);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.realtime) {
            this.cpu.setRealTime(this.realtime.isSelected());
        }
    }

    @Override
    public void setEmulation(boolean mode) {
        this.name.setEditable(false);
        this.clock.setEditable(!mode);
        this.clockPerCycle.setEditable(!mode);
        this.realtime.setEnabled(!mode);
        this.cycle.setEditable(false);
    }

    @Override
    public void update(CPU cpu) {
        this.clock.setValue(cpu.getClock());
        this.clockPerCycle.setValue(cpu.getClockPerCycle());
        this.realtime.setSelected(cpu.getRealTime());
        this.cycle.setValue(cpu.getCycle());
        double d = cpu.getUsage();
        this.usage.setText(d + "%");
        this.memory.setValue(Runtime.getRuntime().totalMemory());
    }
}

