/*
 * Decompiled with CFR 0.152.
 */
package jmce.atmel;

import jmce.atmel.AT89C51RD2Constants;
import jmce.intel.mcs51.JPorts;
import jmce.intel.mcs51.MCS52;
import jmce.intel.mcs51.Port;
import jmce.intel.mcs51.Ports;
import jmce.sim.CPU;
import jmce.sim.CallListener;
import jmce.sim.Memory;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.sim.memory.PersistentMemory;
import jmce.sim.memory.PlainMemory;
import jmce.util.Hex;
import jmce.util.Logger;

public class AT89C51RD2
extends MCS52
implements AT89C51RD2Constants,
CallListener {
    private static final Logger log = Logger.getLogger(AT89C51RD2.class);

    public AT89C51RD2() {
        this.setName("AT89C51RD2");
        this.setAuxrDptrEnabled();
    }

    @Override
    protected void initMemories() {
        Memory m = this.getMemoryForName("CODE");
        if (m == null) {
            m = new PersistentMemory("CODE", this.getName() + ".flash", 65536);
            this.addHardware(m);
        }
        if ((m = this.getMemoryForName("XDATA")) == null) {
            this.addHardware(new PlainMemory("XDATA", 2048));
        }
        super.initMemories();
    }

    @Override
    protected void initNames() {
        super.initNames();
        this.setSfrName(192, "P4");
        this.setSfrName(232, "P5");
        this.setSfrName(143, "CKCON");
    }

    @Override
    protected void initPeripherals() throws SIMException {
        if (this.getHardware((Class)Ports.class) == null) {
            Port.sfrPorts[4] = 192;
            Port.sfrPorts[5] = 232;
            Ports p = new Ports(6);
            this.addHardware(p);
            p.addHardware(new JPorts());
        }
        super.initPeripherals();
    }

    @Override
    protected void initListeners() throws SIMException {
        super.initListeners();
        this.addIOWriteListener(143, new MemoryWriteListener(){

            @Override
            public void writeMemory(Memory memory, int address, int value, int oldValue) throws SIMException {
                AT89C51RD2.this.setClockPerCycle((value & 1) != 0 ? 6 : 12);
            }
        });
        this.setCallListener(65520, this);
    }

    @Override
    public int call(CPU cpu, int pc) throws SIMException {
        log.info("CALL AT " + Hex.formatWord(pc) + " R1=" + this.r(1));
        switch (this.r(1)) {
            case 9: {
                int dest = this.getDptr(0);
                int source = this.getDptr(1);
                for (int i = 0; i < this.acc(); ++i) {
                    this.code(dest + i, this.xdata(source + i));
                }
                this.acc(0);
                break;
            }
            default: {
                throw new SIMException("API R1 " + this.r(1) + " A = " + this.acc() + " DPTR0 = " + Hex.formatWord(this.getDptr(0)) + " DPTR1 = " + Hex.formatWord(this.getDptr(1)));
            }
        }
        return 0;
    }
}

