/*
 * Decompiled with CFR 0.152.
 */
package jmce.intel.mcs51;

import jmce.intel.mcs51.MCS51;
import jmce.intel.mcs51.MCS51Constants;
import jmce.sim.Interrupt;
import jmce.sim.Memory;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.util.FastArray;

public class Interrupt8051
extends Interrupt
implements MemoryWriteListener,
MCS51Constants {
    private FastArray<InterruptCondition> interruptConditions = new FastArray();
    private MCS51 cpu;

    public Interrupt8051(MCS51 cpu, String name, int v) throws SIMException {
        super(cpu, name, v);
        this.setEnabled(true);
        this.cpu = cpu;
    }

    private boolean isInterruptActive() throws SIMException {
        int i = this.interruptConditions.getSize();
        while (--i >= 0) {
            InterruptCondition ii = this.interruptConditions.get(i);
            if (ii.isActive()) continue;
            return false;
        }
        return true;
    }

    public void addInterruptCondition(int sfr, int mask) {
        this.interruptConditions.add(new InterruptCondition(sfr, mask));
        this.cpu.addIOWriteListener(sfr, this);
    }

    @Override
    public void writeMemory(Memory m, int address, int value, int oldValue) throws SIMException {
        this.setActive(this.isInterruptActive());
    }

    class InterruptCondition {
        private int sfr;
        private int mask;

        public boolean isActive() throws SIMException {
            return (Interrupt8051.this.cpu.getIOByte(this.sfr) & this.mask) != 0;
        }

        public InterruptCondition(int sfr, int mask) {
            this.sfr = sfr;
            this.mask = mask;
        }
    }
}

