/*
 * Decompiled with CFR 0.152.
 */
package jmce.intel.mcs51;

import jmce.intel.mcs51.Port;
import jmce.sim.AbstractPeripheral;
import jmce.sim.Hardware;
import jmce.sim.SIMException;

public class Ports
extends AbstractPeripheral {
    private int[] disableMasks;
    private int numPort;

    public Ports(int n) {
        this.setName("Ports");
        this.setNumPort(n);
    }

    public Ports() {
        this(0);
    }

    public void setNumPort(int n) {
        this.numPort = n;
        this.disableMasks = new int[n];
    }

    public int getNumPort() {
        return this.numPort;
    }

    public Port getPort(int n) {
        return (Port)this.getHardware(Port.class, n);
    }

    @Override
    public void init(Hardware parent) throws SIMException {
        Hardware p;
        int i;
        for (i = 0; i < this.numPort; ++i) {
            p = this.getHardware(Port.class, i);
            if (p != null) continue;
            this.addHardware(new Port(i));
        }
        for (i = 0; i < this.numPort; ++i) {
            p = this.getPort(i);
            ((Port)p).setDisableMask(this.disableMasks[i]);
        }
        super.init(parent);
    }

    public void setDisableMask(int n, int mask) {
        this.disableMasks[n] = mask;
    }

    public int getSfrP(int n) {
        return Port.sfrPorts[n];
    }

    public int getSfrM1(int n) {
        return Port.sfrM1s[n];
    }

    public int getSfrM2(int n) {
        return Port.sfrM2s[n];
    }

    @Override
    public String toString() {
        return "Port 0-" + this.numPort;
    }
}

