/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim;

import jmce.sim.AbstractHardware;
import jmce.sim.CPU;
import jmce.sim.Peripheral;
import jmce.sim.SIMException;
import jmce.util.Timeout;

public abstract class AbstractPeripheral
extends AbstractHardware
implements Peripheral {
    private static final Timeout timeout = new Timeout(10000L);
    protected CPU cpu = null;

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        this.cpu = cpu;
    }

    @Override
    public int idle() throws SIMException {
        if (this.cpu != null) {
            return this.cpu.idle();
        }
        long startTime = System.currentTimeMillis();
        Thread.yield();
        int n = (int)(System.currentTimeMillis() - startTime);
        return n;
    }

    public AbstractPeripheral(String name) {
        super(name);
    }

    public AbstractPeripheral() {
        super("Peripheral");
    }

    protected final void setIdle() throws SIMException {
        if (timeout.isExpired() && (this.cpu == null || !this.cpu.getRealTime())) {
            this.idle();
        }
    }

    protected final void setLive() {
        timeout.restart();
    }
}

