/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim;

import jmce.sim.AbstractPeripheral;
import jmce.sim.I2cSlave;
import jmce.sim.Memory;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.sim.memory.MemoryBit;
import jmce.sim.memory.OpenCollectorMemoryBit;
import jmce.util.Hex;
import jmce.util.Logger;

public class I2cBus
extends AbstractPeripheral
implements MemoryWriteListener {
    private static Logger log = Logger.getLogger(I2cBus.class);
    protected MemoryBit SCL;
    protected MemoryBit SDA;
    private boolean oldScl;
    private boolean oldSda;
    private int bitCount;
    private int value;
    private I2cSlave ph;
    private boolean ack;
    private boolean read;
    private boolean ignore;
    private int byteCount;
    private boolean lastByte;

    public I2cBus() {
        super("I2CBUS");
    }

    public void setScl(OpenCollectorMemoryBit scl) {
        this.SCL = scl;
        this.SCL.addMemoryWriteListener(this);
    }

    public void setSda(OpenCollectorMemoryBit sda) {
        this.SDA = sda;
        this.SDA.addMemoryWriteListener(this);
    }

    @Override
    public void reset() throws SIMException {
        super.reset();
        this.SDA.set(true);
        this.SCL.set(true);
        this.oldSda = this.SDA.get();
        this.oldScl = this.SCL.get();
        this.i2cIdle();
    }

    private void i2cIdle() {
        this.bitCount = 0;
        this.ph = null;
        this.ack = false;
        this.read = false;
        this.ignore = false;
        this.lastByte = false;
        this.byteCount = 0;
    }

    protected void i2cStart() {
        this.bitCount = 0;
        if (this.ph != null) {
            I2cSlave tmp = this.ph;
            log.fine("Repeated start condition");
            this.i2cIdle();
            this.ph = tmp;
        } else {
            log.fine("Start condition");
            this.i2cIdle();
        }
    }

    protected void i2cStop() {
        log.fine("Stop condition");
        this.i2cIdle();
    }

    private boolean searchSlave(int a) {
        a &= 0xFE;
        int i = 0;
        while (true) {
            this.ph = (I2cSlave)this.getHardware(I2cSlave.class, i);
            if (this.ph == null) break;
            if (this.ph.i2cAddress(a)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void i2cRecv(int value) throws SIMException {
        log.fine("I2CRECV " + Hex.formatByte(value));
        if (this.ph == null) {
            if (this.searchSlave(value)) {
                log.fine("Found " + this.ph);
                this.ack = this.ph.i2cWrite(this.byteCount++, value);
            } else {
                log.info("Not found Peripheral at " + Hex.formatByte(value));
            }
        } else {
            this.ack = this.ph.i2cWrite(this.byteCount++, value);
        }
    }

    protected void i2cSend(boolean sda) throws SIMException {
        if (this.lastByte) {
            return;
        }
        switch (this.bitCount) {
            case 0: {
                this.value = this.ph.i2cRead(this.byteCount++) & 0xFF;
            }
            default: {
                if ((this.value & 0x80) != 0) {
                    this.SDA.set(true);
                } else {
                    this.SDA.set(false);
                }
                this.value <<= 1;
                ++this.bitCount;
                break;
            }
            case 8: {
                this.lastByte = sda;
                log.finer("Last byte " + this.lastByte);
                ++this.bitCount;
            }
        }
        log.finer("Send Clock " + this.bitCount + " Bit " + this.SDA.get() + " value " + Hex.formatByte(this.value));
    }

    protected void i2cRecv(boolean sda) throws SIMException {
        switch (this.bitCount) {
            case 0: {
                this.value = 0;
            }
            default: {
                this.value <<= 1;
                if (sda) {
                    this.value |= 1;
                }
                if (++this.bitCount != 8) break;
                this.i2cRecv(this.value);
                break;
            }
            case 8: {
                ++this.bitCount;
            }
        }
    }

    protected void i2cRise(boolean bit) throws SIMException {
        log.finer("I2CRise " + bit);
        if (this.read) {
            this.i2cSend(bit);
        } else {
            this.i2cRecv(bit);
        }
    }

    protected void i2cFail(boolean bit) throws SIMException {
        log.finer("I2CFail " + bit);
        if (this.bitCount == 8) {
            if (this.read) {
                log.finer("Release SDA");
                this.SDA.set(true);
            } else if (this.ack) {
                log.finer("ACK SDA");
                this.SDA.set(false);
            } else {
                this.SDA.set(true);
                log.finer("NACK SDA");
            }
        } else if (this.bitCount == 9) {
            this.ack = false;
            if (!this.read) {
                this.SDA.set(true);
            }
            this.bitCount = 0;
            if (this.byteCount == 1) {
                boolean bl = this.read = (this.value & 1) != 0;
                if (this.read) {
                    log.finer("Read operation");
                } else {
                    log.finer("Write operation");
                }
            }
        }
    }

    protected void bus(boolean scl, boolean sda) throws SIMException {
        if (this.ignore) {
            return;
        }
        if (this.oldScl == scl && sda == this.oldSda) {
            return;
        }
        this.ignore = true;
        log.finest("SCL=" + scl + ",SDA=" + sda + " SCL=" + this.oldScl + ",SDA=" + this.oldSda);
        if (scl && this.oldScl && this.oldSda && !sda) {
            this.i2cStart();
        }
        if (scl && this.oldScl && !this.oldSda && sda) {
            this.i2cStop();
        }
        if (!this.oldScl && scl) {
            this.i2cRise(sda);
        }
        if (this.oldScl && !scl) {
            this.i2cFail(sda);
        }
        this.oldScl = this.SCL.get();
        this.oldSda = this.SDA.get();
        this.ignore = false;
    }

    @Override
    public void writeMemory(Memory m, int address, int value, int oldValue) throws SIMException {
        this.bus(this.SCL.get(), this.SDA.get());
    }
}

