/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.cpm;

import java.util.Arrays;

public class FCB {
    static final byte b00 = 0;
    public static final int SIZE = 32;
    public static final byte DELETED = -27;
    public static final int USER = 0;
    public static final int EX = 12;
    public static final int RC = 15;
    private byte[] fcb = new byte[32];

    public FCB() {
        this.clear();
    }

    public void clear() {
        Arrays.fill(this.fcb, (byte)0);
    }

    public void getBuffer(byte[] buffer, int from) {
        System.arraycopy(this.fcb, 0, buffer, from, 32);
    }

    public void setBuffer(byte[] buffer, int from) {
        System.arraycopy(buffer, from, this.fcb, 0, 32);
    }

    public byte[] getBytes() {
        return this.fcb;
    }

    public int getUser() {
        return this.fcb[0] & 0xFF;
    }

    public void setUser(int user) {
        this.fcb[0] = (byte)user;
    }

    public void setFileName(String name) {
        Arrays.fill(this.fcb, 1, 12, (byte)32);
        int j = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '.') {
                j = 8;
                continue;
            }
            this.fcb[1 + j++] = (byte)c;
        }
    }

    public String getFileName() {
        char c;
        int i;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < 8; ++i) {
            c = (char)this.fcb[i + 1];
            if ((c = (char)(c & 0x7F)) == ' ') continue;
            sb.append(c);
        }
        sb.append('.');
        for (i = 0; i < 3; ++i) {
            c = (char)this.fcb[i + 9];
            if ((c = (char)(c & 0x7F)) == ' ') continue;
            sb.append(c);
        }
        String fileName = sb.toString();
        if (fileName.endsWith(".")) {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        return fileName;
    }

    public void setDeleted() {
        this.fcb[0] = -27;
    }

    public boolean isDeleted() {
        return this.fcb[0] == -27;
    }

    public int getRC() {
        return this.fcb[15] & 0xFF;
    }

    public void setRC(int rc) {
        this.fcb[15] = (byte)rc;
    }

    public int getEX() {
        return this.fcb[12] & 0xFF;
    }

    public void setEX(int ex) {
        this.fcb[12] = (byte)ex;
    }

    public int getBlockByte(int block) {
        return this.fcb[16 + block] & 0xFF;
    }

    public int getBlockWord(int block) {
        return (this.fcb[16 + block * 2 + 0] & 0xFF) + (this.fcb[16 + block * 2 + 1] & 0xFF) * 256;
    }

    public void setBlockByte(int block, int value) {
        this.fcb[16 + block] = (byte)value;
    }

    public void setBlockWord(int block, int value) {
        this.setBlockByte(block * 2 + 0, value & 0xFF);
        this.setBlockByte(block * 2 + 1, value >> 8);
    }

    public void clearBlocks() {
        Arrays.fill(this.fcb, 16, 32, (byte)0);
    }

    public boolean getAttributeFifo() {
        return (this.fcb[1] & 0x80) != 0;
    }

    public boolean getAttributeReadOnly() {
        return (this.fcb[9] & 0x80) != 0;
    }

    public boolean getAttributeGlobal() {
        return (this.fcb[10] & 0x80) != 0;
    }

    public boolean getAttributeArchive() {
        return (this.fcb[11] & 0x80) != 0;
    }
}

