/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.cpu;

import jmce.sim.AbstractHardware;
import jmce.sim.Register;
import jmce.sim.RegisterReadListener;
import jmce.sim.RegisterWriteListener;
import jmce.sim.SIMException;
import jmce.util.Hex;

public class PairRegister
extends AbstractHardware
implements Register {
    Register l;
    Register h;

    public PairRegister(String name, Register l, Register h) {
        super(name);
        this.l = l;
        this.h = h;
    }

    @Override
    public void setRegister(int value) throws SIMException {
        this.l.setRegister(value);
        this.h.setRegister(value >> this.l.getWidth());
    }

    @Override
    public void setResetValue(int value) {
        this.l.setResetValue(value);
        this.h.setResetValue(value >> this.l.getWidth());
    }

    @Override
    public int getRegister() throws SIMException {
        return this.l.getRegister() | this.h.getRegister() << this.l.getWidth();
    }

    @Override
    public int getWidth() {
        return this.l.getWidth() + this.h.getWidth();
    }

    @Override
    public int getFamily() {
        return this.l.getFamily();
    }

    @Override
    public String hexValue(int value) {
        return Hex.formatWord(value);
    }

    @Override
    public String descValue() throws SIMException {
        return this.hexValue();
    }

    @Override
    public String hexValue() throws SIMException {
        return this.hexValue(this.getRegister());
    }

    @Override
    public void addRegisterWriteListener(RegisterWriteListener l) {
    }

    @Override
    public void addRegisterReadListener(RegisterReadListener l) {
    }

    @Override
    public void reset() throws SIMException {
        super.reset();
        this.l.reset();
        this.h.reset();
    }
}

