/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.memory;

import jmce.sim.Memory;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;

public class MemoryBits {
    protected int mask;
    protected int shift;
    private int width;
    private Memory memory;
    private int address;

    public MemoryBits(Memory memory, int address, int shift, int width) {
        this.width = width;
        this.mask = (1 << width) - 1;
        this.shift = shift;
        this.address = address;
        this.memory = memory;
    }

    public int getWidth() {
        return this.width;
    }

    public int getBits() throws SIMException {
        int value = this.memory.getMemory(this.address);
        value >>= this.shift;
        return value &= this.mask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBits(int v) throws SIMException {
        Memory memory = this.memory;
        synchronized (memory) {
            int value = this.memory.getMemory(this.address);
            value &= ~(this.mask << this.shift);
            this.memory.setMemory(this.address, value |= (v &= this.mask) << this.shift);
        }
    }

    public void addMemoryWriteListener(MemoryWriteListener l) {
        this.memory.addMemoryWriteListener(this.address, l);
    }
}

