/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.serial;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import jmce.sim.SIMException;
import jmce.sim.SIMIOException;
import jmce.sim.serial.TCPSocket;
import jmce.util.Logger;

public class TCPServer
extends TCPSocket {
    private static Logger log = Logger.getLogger(TCPServer.class);
    private ServerSocket ss = null;

    public TCPServer() {
        this(2023);
    }

    public TCPServer(int port) {
        this.setPort(port);
    }

    @Override
    protected void close() {
        super.close();
        if (this.ss != null) {
            try {
                this.ss.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ss = null;
        }
    }

    @Override
    protected void connect() throws SIMException {
        log.info(" Wait for connection on port " + this.getPort());
        try {
            this.ss = new ServerSocket(this.getPort());
            Socket s = this.ss.accept();
            log.info("Connected with " + s);
            this.setSocket(s);
        }
        catch (IOException e) {
            throw new SIMIOException(this.toString(), " accept");
        }
    }

    @Override
    public String toString() {
        return "TCPServer on " + this.getPort() + " Sent=" + this.sent + ",Rcvd=" + this.rcvd;
    }
}

