/*
 * Decompiled with CFR 0.152.
 */
package jmce.swing;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import jmce.swing.Util;

public abstract class SwingThread
extends JDialog
implements Runnable {
    private static final long serialVersionUID = 1L;
    JButton cancel = new JButton("Cancel");
    JProgressBar pb = new JProgressBar(0, 100);
    private Exception ex = null;
    private boolean cancelled = false;

    public SwingThread(JFrame parent, String title, String info) {
        super((Frame)parent, true);
        this.setTitle(title);
        GridBagConstraints g = new GridBagConstraints();
        JPanel p = new JPanel(new GridBagLayout());
        g.gridx = 0;
        g.gridy = 0;
        g.gridwidth = 1;
        g.gridheight = 1;
        g.insets = new Insets(10, 10, 10, 10);
        g.fill = 1;
        this.pb.setStringPainted(true);
        p.add((Component)new JLabel(info), g);
        ++g.gridy;
        p.add((Component)this.pb, g);
        ++g.gridy;
        g.fill = 0;
        p.add((Component)this.cancel, g);
        this.setContentPane(p);
        this.pack();
        Icon icon = Util.getIcon("cancel.gif");
        this.cancel.setIcon(icon);
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SwingThread.this.cancel.setEnabled(false);
                SwingThread.this.cancelled = true;
            }
        });
        Util.setLocationCenterTo(this, parent);
    }

    public void setMaximum(int v) {
        this.pb.setMaximum(v);
    }

    public void setValue(int v) {
        this.pb.setValue(v);
    }

    @Override
    public final void run() {
        try {
            this.doWork();
        }
        catch (Exception ex) {
            this.ex = ex;
        }
        this.setVisible(false);
    }

    public final void start() {
        Thread t = new Thread(this);
        t.start();
        this.setVisible(true);
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }

    public final Exception getException() {
        return this.ex;
    }

    public abstract void doWork() throws Exception;
}

