/*
 * Decompiled with CFR 0.152.
 */
package jmce.util;

import jmce.sim.SIMException;

public class Hex {
    private Hex() {
    }

    private static String toHex(int value, int len) {
        String s = Integer.toHexString(value);
        while (s.length() < len) {
            s = "0" + s;
        }
        return s.toUpperCase();
    }

    public static String formatValue(int value, int len) {
        return Hex.toHex(value, len);
    }

    public static String formatByte(int value) {
        return Hex.toHex(value, 2);
    }

    public static String formatDword(int value) {
        return Hex.toHex(value, 8);
    }

    public static String formatWord(int value) {
        return Hex.toHex(value, 4);
    }

    public static int getHex(String line, int pos, int len) throws SIMException {
        int value = 0;
        for (int i = 0; i < len; ++i) {
            value <<= 4;
            value |= Hex.getDigit(line, pos++);
        }
        return value;
    }

    public static int getWord(String line, int pos) throws SIMException {
        return Hex.getHex(line, pos, 4);
    }

    public static int getByte(String line, int pos) throws SIMException {
        return Hex.getHex(line, pos, 2);
    }

    public static int getDigit(String line, int pos) throws SIMException {
        char c = line.charAt(pos);
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new SIMException(c + " is not a valid Hex digit!");
    }
}

