/*
 * Decompiled with CFR 0.152.
 */
package jmce.viara.diseqc;

import jmce.atmel.AT24C16;
import jmce.sim.CPU;
import jmce.sim.Hardware;
import jmce.sim.I2cBus;
import jmce.sim.Memory;
import jmce.sim.SIMException;
import jmce.viara.diseqc.Diseqc;

public class DiseqcI2cBus
extends I2cBus {
    private Memory memory = null;

    @Override
    public void init(Hardware parent) throws SIMException {
        this.memory = (AT24C16)this.getHardware((Class)AT24C16.class);
        if (this.memory == null) {
            this.memory = new AT24C16();
            this.addHardware(this.memory);
        }
        super.init(parent);
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        Diseqc d = (Diseqc)cpu;
        this.setScl(d.getSfrBitOpenCollector(128, 6));
        this.setSda(d.getSfrBitOpenCollector(128, 7));
    }

    public int getPosition() throws SIMException {
        return this.memory.getMemory(4) * 256 + this.memory.getMemory(5);
    }
}

