/*
 * Decompiled with CFR 0.152.
 */
package jmce.viara.s400;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import jmce.hitachi.HD44780;
import jmce.sim.AbstractPeripheral;
import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.sim.SwingHardware;
import jmce.swing.KLed;
import jmce.swing.KMatrixKeyboard;
import jmce.swing.Util;
import jmce.viara.s400.S400;

public class Display
extends AbstractPeripheral
implements MemoryWriteListener,
MemoryReadListener,
SwingHardware {
    private static final int DISPLAY_RS = 1;
    private static final int DISPLAY_READ = 2;
    private static final int DISPLAY_EN = 4;
    private HD44780 lcd = new HD44780();
    S400 s4;
    private JPanel p = new JPanel(new GridBagLayout());
    private KLed redLed;
    private KLed greenLed;
    private KMatrixKeyboard kbd = new KMatrixKeyboard();

    public Display() {
        this.setName("Lcd 2x16");
        this.redLed = new KLed(Color.RED);
        this.greenLed = new KLed(Color.GREEN);
        this.kbd.setNumRows(4);
        this.kbd.setNumCols(5);
        this.kbd.setKey(0, 0, '1');
        this.kbd.setKey(0, 1, '2');
        this.kbd.setKey(0, 2, '3');
        this.kbd.setComponent(0, 3, this.greenLed);
        this.kbd.setKey(0, 4, 'E');
        this.kbd.setKey(1, 0, '4');
        this.kbd.setKey(1, 1, '5');
        this.kbd.setKey(1, 2, '6');
        this.kbd.setComponent(1, 3, this.redLed);
        this.kbd.setKey(1, 4, 'T');
        this.kbd.setKey(2, 0, '7');
        this.kbd.setKey(2, 1, '8');
        this.kbd.setKey(2, 2, '9');
        this.kbd.setKey(2, 3, '0');
        this.kbd.setKey(2, 4, 'E');
        Util.setBox(this.lcd);
        Util.setBox(this.kbd);
        GridBagConstraints g = new GridBagConstraints();
        g.gridx = 0;
        g.gridy = 0;
        g.gridwidth = 1;
        g.gridheight = 1;
        g.anchor = 10;
        g.fill = 0;
        g.insets = new Insets(2, 2, 2, 2);
        this.p.add((Component)this.lcd, g);
        g.gridx = 0;
        ++g.gridy;
        this.p.add((Component)this.kbd, g);
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        this.s4 = (S400)cpu;
        this.s4.addIOWriteListener(192, this);
        this.s4.addIOWriteListener(232, this);
        this.s4.addIOWriteListener(160, this);
    }

    @Override
    public int readMemory(Memory memory, int address, int value) throws SIMException {
        return value;
    }

    @Override
    public void writeMemory(Memory memory, int address, int value, int oldValue) throws SIMException {
        if (address == 232) {
            if ((value & 4) != 0 && (oldValue & 4) == 0) {
                boolean read = (value & 2) != 0;
                int a = value & 1;
                if (read) {
                    int data = this.lcd.readMemory(memory, a, 0);
                    this.s4.sfr(192, data);
                } else {
                    int data = this.s4.sfr(192);
                    this.lcd.writeMemory(memory, a, data, 0);
                }
            }
        } else if (address == 160) {
            this.redLed.setLed((value & 4) != 0);
            this.greenLed.setLed((value & 8) != 0);
        }
    }

    @Override
    public Component getComponent() {
        return this.p;
    }
}

