/*
 * Decompiled with CFR 0.152.
 */
package jmce.zilog.z80;

import jmce.intel.i8080.INT;
import jmce.sim.SIMException;
import jmce.util.Hex;
import jmce.zilog.z80.Z80;

public class INTZ80
extends INT {
    private Z80 z80;

    public INTZ80(Z80 z80, String name) throws SIMException {
        super(z80, name);
        this.z80 = z80;
        this.setEnabled(true);
    }

    @Override
    public final int getVector() throws SIMException {
        if ((this.vector & 1) != 0) {
            throw new SIMException("Invalid vector " + Hex.formatByte(this.vector));
        }
        switch (this.z80.im()) {
            default: {
                throw new SIMException("IM0 not supported");
            }
            case 1: {
                return 56;
            }
            case 2: 
        }
        int a = this.z80.I() << 8 | this.vector;
        int w = this.z80.getWord(a);
        return w;
    }

    @Override
    public String toString() {
        switch (this.z80.im()) {
            case 0: {
                return super.toString() + " IM0";
            }
            case 1: {
                return super.toString() + " IM1 (38)";
            }
            case 2: {
                try {
                    return super.toString() + " IM2 V=" + Hex.formatByte(this.getVector());
                }
                catch (SIMException ignore) {
                    return "IM2 V=xx";
                }
            }
        }
        return super.toString();
    }
}

