/***************************************************************************
                          degadlgimpl.cpp  -  description
                             -------------------
    begin                : Wed Sep 19 2001
    copyright            : (C) 2001 by Scott Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "degadlgimpl.h"
#include "dega.h"
#include <qstring.h>
#include <kfiledialog.h>
#include <qfiledialog.h>
#include <qlabel.h>
#include <qtabwidget.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qcheckbox.h>

DegaDlgImpl::DegaDlgImpl(const QString &system, QWidget *parent, const char *name, bool modal, WFlags fl) : DegaDlg(parent, name, modal, fl) {
	_dega = new Dega(system);

	lineeditExecutable->setText(_dega->executable());
	lineeditRom->setText(_dega->romDir());

	checkboxPal->setChecked(_dega->usePal());
	checkboxSound->setChecked(_dega->enableSound());
	checkboxFullscreen->setChecked(_dega->fullscreen());

	radiobutton0->setChecked(false);
	radiobutton1->setChecked(false);
	radiobutton2->setChecked(false);
	switch (_dega->machineType())
	{
		case 0: radiobutton0->setChecked(true); break;
		case 1: radiobutton1->setChecked(true); break;
		case 2: radiobutton2->setChecked(true); break;
		default: radiobutton0->setChecked(true); break;
	}
}

DegaDlgImpl::~DegaDlgImpl(){
	delete _dega;
}

void DegaDlgImpl::slotBrowseExecutable()
{
	QString string(KFileDialog::getOpenFileName(":"));
	if (!string.isNull()) lineeditExecutable->setText(string);
}

void DegaDlgImpl::slotBrowseRom()
{
	QString string(KFileDialog::getExistingDirectory(":"));
	if (!string.isNull()) lineeditRom->setText(string);
}

void DegaDlgImpl::slotDefaults()
{
	QString tabLabel = tabDega->tabLabel(tabDega->currentPage());

	if (tabLabel == "Filesystem")
	{
		lineeditExecutable->setText(_dega->defaultExecutable());
		lineeditRom->setText(_dega->defaultRomDir());
	}

	if (tabLabel == "Preferences")
	{
		checkboxPal->setChecked(_dega->defaultUsePal());
		checkboxSound->setChecked(_dega->defaultEnableSound());
		checkboxFullscreen->setChecked(_dega->defaultFullscreen());

		radiobutton0->setChecked(false);
		radiobutton1->setChecked(false);
		radiobutton2->setChecked(false);
		int paddle = _dega->defaultMachineType();
		switch(paddle)
		{
			case 0: radiobutton0->setChecked(true); break;
			case 1: radiobutton1->setChecked(true); break;
			case 2: radiobutton2->setChecked(true); break;
			default: radiobutton0->setChecked(true); break;
		}
	}
}

void DegaDlgImpl::slotSave()
{
	_dega->setExecutable(lineeditExecutable->text());
	_dega->setRomDir(lineeditRom->text());
	_dega->setEnableSound(checkboxSound->isChecked());
	_dega->setFullscreen(checkboxFullscreen->isChecked());
	_dega->setUsePal(checkboxPal->isChecked());
	if (radiobutton0->isChecked()) _dega->setMachineType(0);
	if (radiobutton1->isChecked()) _dega->setMachineType(1);
	if (radiobutton2->isChecked()) _dega->setMachineType(2);

	_dega->save();
	accept();
}
