/***************************************************************************
                          kemulator.h  -  main application
                             -------------------
    begin                : Sun Sep 16 06:29:12 EDT 2001
    copyright            : (C) 2001 by Scott Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KEMULATOR_H
#define KEMULATOR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for KDE 
#include <kapp.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kaction.h>
#include <qstring.h>

class KemulatorWidget;
class Emulator;
class Mess;
class Snes9x;
class Fce;
class Stella;
class Dega;
class Dgen;

/**
  * The base class for Kuef application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar.
  *
  * KuefApp reimplements the methods that KMainWindow provides for main window handling and supports
  * full session management as well as using KActions.
  * @see KMainWindow
  * @see KApplication
  * @see KConfig
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.2 code generation
  */
class KemulatorApp : public KMainWindow
{
Q_OBJECT

public:
	/** construtor of KemulatorApp, calls all init functions to create the application */
	KemulatorApp(QWidget* parent=0, const char* name=0);
	/** Destructor */
	~KemulatorApp();

protected:
	/** save general Options like all bar positions and status as well as the geometry 
	 * to the configuration file */ 	
	void saveOptions();
	/** read general Options again and initialize all variables */
	void readOptions();
	/** initializes the KActions of the application */
	void initActions();
	/** sets up the statusbar for the main window by initialzing a statuslabel.  */
	void initStatusBar();
	/** sets up the widget for the main window */
	void initCentralWidget();
	/** queryExit is called by KTMainWindow when the application is closed
	 * Against the default implementation that just returns true, this calls saveOptions() 
	 * to save the settings of the last window's properties.
	 * @see KTMainWindow#queryExit
	 * @see KTMainWindow#closeEvent
	 */
	virtual bool queryExit();

public slots:
	/** play (emulate) the current ROM */
	void slotFilePlay();
	/** selects a random ROM from the romlist */
	void slotFileRandom();
	/** closes the window by calling close(), then quits the application. */
	void slotFileQuit();
	/** run the emulator, MESS (apple2c), environment */
	void slotEmulatorMess_apple2c();
	/** run the emulator, MESS (apple2e), environment */
	void slotEmulatorMess_apple2e();
	/** run the emulator, Stella, environment */
	void slotEmulatorStella();
	/** run the emulator, Dega (Master System), environment */
	void slotEmulatorDega_sms();
	/** run the emulator, Dega (Game Gear), environment */
	void slotEmulatorDega_gg();
	/** run the emulator, Dgen, environment */
	void slotEmulatorDgen();
	/** run the emulator, MESS (a5200), environment */
	void slotEmulatorMess_a5200();
	/** run the emulator, MESS (a7800), environment */
	void slotEmulatorMess_a7800();
	/** run the emulator, MESS (coleco), environment */
	void slotEmulatorMess_coleco();
	/** run the emulator, MESS (genesis), environment */
	void slotEmulatorMess_genesis();
	/** run the emulator, MESS (intv), environment */
	void slotEmulatorMess_intv();
	/** run the emulator, MESS (nes), environment */
	void slotEmulatorMess_nes();
	/** run the emulator, MESS (nespal), environment */
	void slotEmulatorMess_nespal();
	/** run the emulator, MESS (sms), environment */
	void slotEmulatorMess_sms();
	/** run the emulator, MESS (gg), environment */
	void slotEmulatorMess_gg();
	/** run the emulator, Snes9x, environment */
	void slotEmulatorSnes9x();
	/** run the emulator, Fce, environment */
	void slotEmulatorFce();
	/** run the emulator, MESS (ti99_4a), environment */
	void slotEmulatorMess_ti99_4a();
	/** run the emulator, MESS (vectrex), environment */
	void slotEmulatorMess_vectrex();
	/** brings up a dialog to configure the current emulator */
	void slotEmulatorConfigure();
	/** refreshes the screen (romlist and image) */
	void slotEmulatorRefresh();
	/** toggles the toolbar */
	void slotViewToolBar();
	/** toggles the statusbar */
	void slotViewStatusBar();
	/** changes the statusbar contents for the standard label permanently, used to indicate current actions.
	* @param text the text that is displayed in the statusbar */
	void slotStatusMsg(const QString &text);

	void slotSelected(int);

private:
	void deleteEmulator();
	/** the application main widget */
	KemulatorWidget *kemulatorWidget;
	/** The current emulator in string form */
	QString emulatorString;
	/** the current emulator selected */
	Emulator *emulator;
	/** Mess emulator */
	Mess *mess;
	/** Snes9x emulator */
	Snes9x *snes9x;
	/** Fce emulator */
	Fce *fce;
	/** Stella emulator */
	Stella *stella;
	/** Dega emulator */
	Dega *dega;
	/** Dgen emulator */
	Dgen *dgen;

	/** the configuration object of the application */
	KConfig *config;

	/** "filePlay" action */
	KAction* filePlay;
	/** "fileRandom" action */
	KAction* fileRandom;
	/** "fileQuit" action */
	KAction* fileQuit;
	/** "emulatorMess_apple2c" action */
	KAction* emulatorMess_apple2c;
	/** "emulatorMess_apple2e" action */
	KAction* emulatorMess_apple2e;
	/** "emulatorStella" action */
	KAction* emulatorStella;
	/** "emulatorDega_sms" action */
	KAction* emulatorDega_sms;
	/** "emulatorDega_gg" action */
	KAction* emulatorDega_gg;
	/** "emulatorDgen" action */
	KAction* emulatorDgen;
	/** "emulatorMess_a5200" action */
	KAction* emulatorMess_a5200;
	/** "emulatorMess_a7800" action */
	KAction* emulatorMess_a7800;
	/** "emulatorMess_coleco" action */
	KAction* emulatorMess_coleco;
	/** "emulatorMess_genesis" action */
	KAction* emulatorMess_genesis;
	/** "emulatorMess_intv" action */
	KAction* emulatorMess_intv;
	/** "emulatorMess_nes" action */
	KAction* emulatorMess_nes;
	/** "emulatorMess_nespal" action */
	KAction* emulatorMess_nespal;
	/** "emulatorMess_sms" action */
	KAction* emulatorMess_sms;
	/** "emulatorMess_gg" action */
	KAction* emulatorMess_gg;
	/** "emulatorSnes9x" action */
	KAction* emulatorSnes9x;
	/** "emulatorFce" action */
	KAction* emulatorFce;
	/** "emulatorMess_ti99_4a" action */
	KAction* emulatorMess_ti99_4a;
	/** "emulatorMess_vectrex" action */
	KAction* emulatorMess_vectrex;
	/** "emulatorConfigure" action */
	KAction* emulatorConfigure;
	/** "emulatorRefresh" action */
	KAction* emulatorRefresh;
	/** "viewToolBar" action */
	KToggleAction* viewToolBar;
	/** "viewStatusBar" action */
	KToggleAction* viewStatusBar;
};
 
#endif // KEMULATOR_H
