/***************************************************************************
                          main.cpp  -  main program
                             -------------------
    begin                : Sun Sep 16 06:29:12 EDT 2001
    copyright            : (C) 2001 by Scott Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "kemulator.h"

static const char *description =
	I18N_NOOP("Kemulator - KDE Emulator Frontend");
	
	
static KCmdLineOptions options[] =
{
	{ "+[File]", I18N_NOOP("file to open"), 0 },
	{ 0, 0, 0 }
};

int main(int argc, char *argv[])
{
	KAboutData aboutData( "kemulator", I18N_NOOP("Kemulator"),
		VERSION, description, KAboutData::License_GPL,
		"(c) 2001, Scott Patterson", 0, "http://kemulator.sourceforge.net", "kashis@users.sourceforge.net");
	aboutData.addAuthor("Scott Patterson", 0, "kashis@users.sourceforge.net", "http://kemulator.sourceforge.net");
	KCmdLineArgs::init(argc, argv, &aboutData);
	KCmdLineArgs::addCmdLineOptions(options);

	KApplication app;
	if (app.isRestored())
	{
		RESTORE(KemulatorApp);
	}
	else 
	{
		KemulatorApp *kemulator = new KemulatorApp();
		kemulator->show();
		KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		args->clear();
	}

	return app.exec();
}  
