/***************************************************************************
                          stella.cpp  -  Stella emulator
                             -------------------
    begin                : Tue Mar  6 20:01:53 EST 2001
    copyright            : (C) 2001 by Scott L. Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "stella.h"
#include <qdir.h>
#include <qfileinfo.h>
#include <iostream.h>
#include <kprocess.h>

Stella::Stella() : Emulator()
{
	refresh();
}

void Stella::refresh()
{
	Emulator::refresh();
	load();
	setRomList();
}

void Stella::load()
{
	config->setGroup("Stella");
	Emulator::load();
	setDisplay(config->readEntry("Display", defaultDisplay()));
	setFps(config->readNumEntry("FPS", defaultFps()));
	setOwncmap(config->readBoolEntry("Private Colormap", defaultOwncmap()));
	setPaddle(config->readNumEntry("Paddle", defaultPaddle()));
}

void Stella::save()
{
	config->setGroup("Stella");
	Emulator::save();
	config->writeEntry("Display", display());
	config->writeEntry("FPS", fps());
	config->writeEntry("Private Colormap", owncmap());
	config->writeEntry("Paddle", paddle());
}

// TODO - Could probably optimize the arguments string creation
void Stella::emulate(int index)
{
	// Executable
	QString command;
	command.append(executable());
	command.append(" ");

	// Display
	if (display().length() > 0) 
	{
		command.append("-display ");
		command.append(display());
		command.append(" ");
	}

	// FPS - Frames Per Second
	command.append("-fps ");
	command.append(QString::number(fps()));
	command.append(" ");

	// Private Colormap
	if (owncmap()) command.append("-owncmap ");

	// Mouse emulates paddle
	if (paddle() == 4)
	{
		command.append("-paddle real");
		command.append(" ");
	}
	else
	{
		command.append("-paddle ");
		command.append(QString::number(paddle()));
		command.append(" ");
	}

	// Full path to ROM
	QDir dir(_romDir);
	QFileInfo fileinfo(dir, _romList[index]);
	command.append("\"");
	command.append(fileinfo.filePath());
	command.append("\" ");

	// Run it
	command.append("& ");
	cout << command << endl;
	KShellProcess process;
//	connect(process, SIGNAL(receivedStdout(KProcess *proc, char *buffer, int buflen)), this, SLOT(slotOutput(char *buffer)));
//	connect(process, SIGNAL(receivedStderr(KProcess *proc, char *buffer, int buflen)), this, SLOT(slotOutput(char *buffer)));
	process << command;
	process.start(KProcess::DontCare, KProcess::AllOutput);
}
