/***************************************************************************
                          dega.cpp  -  Dega emulator
                             -------------------
    begin                : Tue Mar  6 20:01:53 EST 2001
    copyright            : (C) 2001 by Scott L. Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dega.h"
#include <qdir.h>
#include <qfileinfo.h>
#include <iostream.h>
#include <kprocess.h>

Dega::Dega(const QString &system) : Emulator()
{        	
  _system = system;
	refresh();
}

void Dega::refresh()
{
	Emulator::refresh();
	load();
	setRomList();
}

void Dega::load()
{
	QString group("Dega");
	group.append("_");
	group.append(_system);
	config->setGroup(group);
	Emulator::load();
	setMachineType(config->readNumEntry("MachineType", defaultMachineType()));
	setUsePal(config->readBoolEntry("Use PAL", defaultUsePal()));
	setEnableSound(config->readBoolEntry("Sound", defaultEnableSound()));
	setFullscreen(config->readBoolEntry("Fullscreen", defaultFullscreen()));
}

void Dega::save()
{
	QString group("Dega");
	group.append("_");
	group.append(_system);
	config->setGroup(group);
	Emulator::save();
	config->writeEntry("MachineType", machineType());
	config->writeEntry("Use PAL", usePal());
	config->writeEntry("Sound", enableSound());
	config->writeEntry("Fullscreen", fullscreen());
}

// TODO - Could probably optimize the arguments string creation
void Dega::emulate(int index)
{
	// Executable
	QString command;
	command.append(executable());
	command.append(" ");

	// Machine Type
	if (machineType() == 1)
	{
		command.append("-g ");
	}
	else if (machineType() == 2)
	{
		command.append("-m ");
	}

  if (usePal())
	{
		command.append("-p ");
	}

	if (!enableSound())
	{
		command.append("-s ");
	}
	if (fullscreen())
	{
		command.append("-f ");
	}

	// Full path to ROM
	QDir dir(_romDir);
	QFileInfo fileinfo(dir, _romList[index]);
	command.append("\"");
	command.append(fileinfo.filePath());
	command.append("\" ");

	// Run it
	command.append("& ");
	cout << command << endl;
	KShellProcess process;
//	connect(process, SIGNAL(receivedStdout(KProcess *proc, char *buffer, int buflen)), this, SLOT(slotOutput(char *buffer)));
//	connect(process, SIGNAL(receivedStderr(KProcess *proc, char *buffer, int buflen)), this, SLOT(slotOutput(char *buffer)));
	process << command;
	process.start(KProcess::DontCare, KProcess::AllOutput);
}
