/***************************************************************************
                          dgendlgimpl.cpp  -  description
                             -------------------
    begin                : Wed Sep 19 2001
    copyright            : (C) 2001 by Scott Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dgendlgimpl.h"
#include "dgen.h"
#include <qstring.h>
#include <kfiledialog.h>
#include <qfiledialog.h>
#include <qlabel.h>
#include <qtabwidget.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qcheckbox.h>

DgenDlgImpl::DgenDlgImpl(QWidget *parent, const char *name, bool modal, WFlags fl) : DgenDlg(parent, name, modal, fl) {
	_dgen = new Dgen();

	lineeditExecutable->setText(_dgen->executable());
	lineeditRom->setText(_dgen->romDir());

	checkboxPal->setChecked(_dgen->usePal());
	checkboxJoystick->setChecked(_dgen->enableJoystick());
	checkboxFullscreen->setChecked(_dgen->fullscreen());
	spinboxScale->setValue(_dgen->scale());
}

DgenDlgImpl::~DgenDlgImpl(){
	delete _dgen;
}

void DgenDlgImpl::slotBrowseExecutable()
{
	QString string(KFileDialog::getOpenFileName(":"));
	if (!string.isNull()) lineeditExecutable->setText(string);
}

void DgenDlgImpl::slotBrowseRom()
{
	QString string(KFileDialog::getExistingDirectory(":"));
	if (!string.isNull()) lineeditRom->setText(string);
}

void DgenDlgImpl::slotDefaults()
{
	QString tabLabel = tabDgen->tabLabel(tabDgen->currentPage());

	if (tabLabel == "Filesystem")
	{
		lineeditExecutable->setText(_dgen->defaultExecutable());
		lineeditRom->setText(_dgen->defaultRomDir());
	}

	if (tabLabel == "Preferences")
	{
		checkboxPal->setChecked(_dgen->defaultUsePal());
		checkboxJoystick->setChecked(_dgen->defaultEnableJoystick());
		checkboxFullscreen->setChecked(_dgen->defaultFullscreen());
		spinboxScale->setValue(_dgen->defaultScale());
	}
}

void DgenDlgImpl::slotSave()
{
	_dgen->setExecutable(lineeditExecutable->text());
	_dgen->setRomDir(lineeditRom->text());
	_dgen->setEnableJoystick(checkboxJoystick->isChecked());
	_dgen->setFullscreen(checkboxFullscreen->isChecked());
	_dgen->setUsePal(checkboxPal->isChecked());
	_dgen->setScale(spinboxScale->value());

	_dgen->save();
	accept();
}
