/***************************************************************************
                          emulator.h  -  Base class for emulators
                             -------------------
    begin                : Wed Sep 19 09:35:25 EDT 2001
    copyright            : (C) 2001 by Scott L. Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EMULATOR_H
#define EMULATOR_H

#include <qstring.h>
#include <qstringlist.h>
#include <kconfig.h>

/* 
 * This class is the base class of all the emulators used. It contains methods and 
 * attributes that ALL emulators will have. Anything generic that affects ALL emulators
 * should go in here. Any emulator that is supported will inherit this code base.
 */
class Emulator
{ 
public:
	/** Constructor */
	Emulator() {};
	/** Destructor */
	virtual ~Emulator() {};

	/** recreate the romlist */
	virtual void refresh();

	/** load the emulator settings */
	virtual void load();
	/** save the emulator settings */
	virtual void save();

	/** command to run the emulator */
	virtual void emulate(int) = 0;

	/** returns the executable */
	QString executable() const;
	/** returns the ROM directory */
	QString romDir() const;
	/** returns the list of ROMs */
	QStringList romList() const;
    
	/** returns the default executable */
	virtual QString defaultExecutable() const = 0;
	/** returns the default ROM directory */
	virtual QString defaultRomDir() const = 0;
    
	/** sets the executable */
	void setExecutable(const QString &executable);
	/** sets the ROM directory */
	void setRomDir(const QString &romDir);
	/** create the list of ROMs from all files in the ROM directory */
	void setRomList();

protected:
	/** the configuration object of the application */
	KConfig *config;
	/** the filename of the executable to run */
	QString _executable;
	/** the directory containing all the ROMs */
	QString _romDir;
	/** the list of ROMs available to emulate */
	QStringList _romList;
};

#endif // EMULATOR_H
