/***************************************************************************
                          fce.h  -  Fce emulator settings
                             -------------------
    begin                : Fri Nov  2 18:29:50 EST 2001
    copyright            : (C) 2001 by Scott L. Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FCE_H
#define FCE_H

#include "emulator.h"
#include <qstring.h>

class Fce : public Emulator
{ 
public:
	/** Constructor */
	Fce();
	/** Destructor */
	~Fce() {};

	/** recreate the romlist */
	virtual void refresh();

	/** load the emulator settings */
	virtual void load();
	/** save the emulator settings */
	virtual void save();

	/** command to run the emulator */
	virtual void emulate(int);

	/** returns the default executable */
	virtual QString defaultExecutable() const { return "fce"; }
	/** returns the default ROM directory */
	virtual QString defaultRomDir() const { return "/usr/local/games/nes/roms/"; }

	/** Audio */
	/** return the sound */
	bool sound() const { return _sound; }
	/** return the soundquality */
	int soundquality() const { return _soundquality; }
	/** return the buffersize */
	int buffersize() const { return _buffersize; }

	/** Video */
	/** return the pal */
	bool pal() const { return _pal; }
	/** return the tvcolor */
	bool tvcolor() const { return _tvcolor; }
	/** return the frameskip */
	int frameskip() const { return _frameskip; }
	/** return the resolution */
	int resolution() const { return _resolution; }

	/** Audio */
	/** return the default sound */
	bool defaultSound() const { return true; }
	/** return the default soundquality */
	int defaultSoundquality() const { return 3; }
	/** return the default buffersize */
	int defaultBuffersize() const { return 4096; }

	/** Video */
	/** return the default pal */
	bool defaultPal() const { return false; }
	/** return the default tvcolor */
	bool defaultTvcolor() const { return true; }
	/** return the default frameskip */
	int defaultFrameskip() const { return 0; }
	/** return the default resolution */
	int defaultResolution() const { return 2; }

	/** Audio */
	/** set the default sound */
	void setSound(bool sound) { _sound = sound; }
	/** set the default soundquality */
	void setSoundquality(int soundquality) { _soundquality = soundquality; }
	/** set the default buffersize */
	void setBuffersize(int buffersize) { _buffersize = buffersize; }

	/** Video */
	/** set the pal */
	void setPal(bool pal) { _pal = pal; }
	/** set the tvcolor */
	void setTvcolor(bool tvcolor) { _tvcolor = tvcolor; }
	/** set the frameskip */
	void setFrameskip(int frameskip) { _frameskip = frameskip; }
	/** set the resolution */
	void setResolution(int resolution) { _resolution = resolution; }

protected:
	/** Audio */
	/** Enable digital sound output (default: enabled) */
	bool _sound;
	/** Sound sample playback rate/quality, 0-7 (default 4) 0 - off, 1 - 8192, 2 - 11025, 3 - 16500, 4 - 22050 (default), 5 - 29300, 6 - 36600, 7 - 44000 */
	int _soundquality;
	/** Sound playback buffer size in bytes 128-4096 */
	int _buffersize;

	/** Video */
	/** Enable pal display */
	bool _pal;
	/** Enable NTSC TV Color emulation */
	bool _tvcolor;
	/** Set this value to deliberately fix the frame skip rate and disable auto-speed regulation */
	int _frameskip;
	/** which resolution to display 1=256x240 2=256x240 fullscreen 3=512x480 4=512x480 fullscreen*/
	int _resolution;
};

#endif // FCE_H
