/***************************************************************************
                          kemulator.cpp  -  main application
                             -------------------
    begin                : Sun Sep 16 06:29:12 EDT 2001
    copyright            : (C) 2001 by Scott Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for QT
#include <qdir.h>
#include <qfileinfo.h>
#include <qpixmap.h>
#include <qmessagebox.h>

// include files for KDE
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kconfig.h>
#include <kstdaction.h>

// application specific includes
#include "kemulator.h"
#include "kemulatorwidget.h"
#include "emulator.h"
#include "mess.h"
#include "messdlgimpl.h"
#include "snes9x.h"
#include "snes9xdlgimpl.h"
#include "fce.h"
#include "fcedlgimpl.h"
#include "stella.h"
#include "stelladlgimpl.h"
#include "dega.h"
#include "degadlgimpl.h"
#include "dgen.h"
#include "dgendlgimpl.h"
#include <typeinfo>
#include <iostream.h>

#define ID_STATUS_MSG 1

KemulatorApp::KemulatorApp(QWidget* , const char* name):KMainWindow(0, name)
{
	emulator = 0;
	mess = 0;
	snes9x = 0;
	fce = 0;
	stella = 0;
	dega = 0;
	dgen = 0;

	config=kapp->config();

	// call inits to invoke all other construction parts
	initStatusBar();
	initActions();
	initCentralWidget();
	readOptions();
}

KemulatorApp::~KemulatorApp()
{
}

void KemulatorApp::initActions()
{
	// Create the actions for menus and toolbars
	filePlay = new KAction(i18n("&Play"), "exec", 0, this, SLOT(slotFilePlay()), actionCollection(), "filePlay");
	fileRandom = new KAction(i18n("&Random"), "unknown", 0, this, SLOT(slotFileRandom()), actionCollection(), "fileRandom");
	fileQuit = KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection(), "fileQuit");
	emulatorMess_apple2c = new KAction(i18n("&Mess apple2c"), 0, this, SLOT(slotEmulatorMess_apple2c()), actionCollection(), "emulatorMess_apple2c");
	emulatorMess_apple2e = new KAction(i18n("&Mess apple2e"), 0, this, SLOT(slotEmulatorMess_apple2e()), actionCollection(), "emulatorMess_apple2e");
	emulatorStella = new KAction(i18n("&Stella"), 0, this, SLOT(slotEmulatorStella()), actionCollection(), "emulatorStella");
	emulatorDega_sms = new KAction(i18n("&Dega Master System"), 0, this, SLOT(slotEmulatorDega_sms()), actionCollection(), "emulatorDega_sms");
	emulatorDega_gg = new KAction(i18n("&Dega Game Gear"), 0, this, SLOT(slotEmulatorDega_gg()), actionCollection(), "emulatorDega_gg");
	emulatorDgen = new KAction(i18n("&Dgen"), 0, this, SLOT(slotEmulatorDgen()), actionCollection(), "emulatorDgen");
	emulatorMess_a5200 = new KAction(i18n("&Mess a5200"), 0, this, SLOT(slotEmulatorMess_a5200()), actionCollection(), "emulatorMess_a5200");
	emulatorMess_a7800 = new KAction(i18n("&Mess a7800"), 0, this, SLOT(slotEmulatorMess_a7800()), actionCollection(), "emulatorMess_a7800");
	emulatorMess_coleco = new KAction(i18n("&Mess coleco"), 0, this, SLOT(slotEmulatorMess_coleco()), actionCollection(), "emulatorMess_coleco");
	emulatorMess_genesis = new KAction(i18n("&Mess genesis"), 0, this, SLOT(slotEmulatorMess_genesis()), actionCollection(), "emulatorMess_genesis");
	emulatorMess_intv = new KAction(i18n("&Mess intv"), 0, this, SLOT(slotEmulatorMess_intv()), actionCollection(), "emulatorMess_intv");
	emulatorMess_nes = new KAction(i18n("&Mess nes"), 0, this, SLOT(slotEmulatorMess_nes()), actionCollection(), "emulatorMess_nes");
	emulatorMess_nespal = new KAction(i18n("&Mess nespal"), 0, this, SLOT(slotEmulatorMess_nespal()), actionCollection(), "emulatorMess_nespal");
	emulatorMess_sms = new KAction(i18n("&Mess sms"), 0, this, SLOT(slotEmulatorMess_sms()), actionCollection(), "emulatorMess_sms");
	emulatorMess_gg = new KAction(i18n("&Mess gg"), 0, this, SLOT(slotEmulatorMess_gg()), actionCollection(), "emulatorMess_gg");
	emulatorSnes9x = new KAction(i18n("&Snes9x"), 0, this, SLOT(slotEmulatorSnes9x()), actionCollection(), "emulatorSnes9x");
	emulatorFce = new KAction(i18n("&Fce"), 0, this, SLOT(slotEmulatorFce()), actionCollection(), "emulatorFce");
	emulatorMess_ti99_4a = new KAction(i18n("&Mess ti99_4a"), 0, this, SLOT(slotEmulatorMess_ti99_4a()), actionCollection(), "emulatorMess_ti99_4a");
	emulatorMess_vectrex = new KAction(i18n("&Mess vectrex"), 0, this, SLOT(slotEmulatorMess_vectrex()), actionCollection(), "emulatorMess_vectrex");
	emulatorConfigure = new KAction(i18n("&Configure"), "configure", 0, this, SLOT(slotEmulatorConfigure()), actionCollection(), "emulatorConfigure");
	emulatorRefresh = new KAction(i18n("&Refresh"), "reload", 0, this, SLOT(slotEmulatorRefresh()), actionCollection(), "emulatorRefresh");
	viewToolBar = KStdAction::showToolbar(this, SLOT(slotViewToolBar()), actionCollection());
	viewStatusBar = KStdAction::showStatusbar(this, SLOT(slotViewStatusBar()), actionCollection());

	// Set the action texts
	fileRandom->setStatusText(i18n("Select a ROM at random"));
	fileQuit->setStatusText(i18n("Quits the application"));
	emulatorMess_a5200->setStatusText(i18n("Loads MESS apple2c ROM list"));
	emulatorMess_a5200->setStatusText(i18n("Loads MESS apple2e ROM list"));
	emulatorStella->setStatusText(i18n("Loads Stella ROM list"));
	emulatorDega_sms->setStatusText(i18n("Loads Dega Master System ROM list"));
	emulatorDega_gg->setStatusText(i18n("Loads Dega Game Gear ROM list"));
	emulatorDgen->setStatusText(i18n("Loads Dgen ROM list"));
	emulatorMess_a5200->setStatusText(i18n("Loads MESS a5200 ROM list"));
	emulatorMess_a7800->setStatusText(i18n("Loads MESS a7800 ROM list"));
	emulatorMess_coleco->setStatusText(i18n("Loads MESS coleco ROM list"));
	emulatorMess_genesis->setStatusText(i18n("Loads MESS genesis ROM list"));
	emulatorMess_intv->setStatusText(i18n("Loads MESS intv ROM list"));
	emulatorMess_nes->setStatusText(i18n("Loads MESS nes ROM list"));
	emulatorMess_nespal->setStatusText(i18n("Loads MESS nespal ROM list"));
	emulatorMess_sms->setStatusText(i18n("Loads MESS sms ROM list"));
	emulatorMess_gg->setStatusText(i18n("Loads MESS gg ROM list"));
	emulatorSnes9x->setStatusText(i18n("Loads Snes9x ROM list"));
	emulatorFce->setStatusText(i18n("Loads Fce ROM list"));
	emulatorMess_ti99_4a->setStatusText(i18n("Loads MESS ti99_4a ROM list"));
	emulatorMess_vectrex->setStatusText(i18n("Loads MESS vectrex ROM list"));
	emulatorConfigure->setStatusText(i18n("Configure the emulator"));
	emulatorRefresh->setStatusText(i18n("Refresh the emulator"));
	viewToolBar->setStatusText(i18n("Enables/disables the toolbar"));
	viewStatusBar->setStatusText(i18n("Enables/disables the statusbar"));

	// use the absolute path to your kemulatorui.rc file for testing purpose in createGUI();
	createGUI();
}


void KemulatorApp::initStatusBar()
{
	statusBar()->insertItem(i18n("Ready."), ID_STATUS_MSG);
}

void KemulatorApp::saveOptions()
{	
	config->setGroup("General Options");
	config->writeEntry("Geometry", size());
	config->writeEntry("Show Toolbar", viewToolBar->isChecked());
	config->writeEntry("Show Statusbar",viewStatusBar->isChecked());
	config->writeEntry("ToolBarPos", (int) toolBar("mainToolBar")->barPos());
	config->writeEntry("Emulator", this->emulatorString);
	config->writeEntry("Last Game Index", kemulatorWidget->currentItem());
}


void KemulatorApp::initCentralWidget()
{
	kemulatorWidget = new KemulatorWidget(this, "kemulatorWidget");
	setCentralWidget(kemulatorWidget);	
}


void KemulatorApp::readOptions()
{
	config->setGroup("General Options");

	// bar status settings
	bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
	viewToolBar->setChecked(bViewToolbar);
	slotViewToolBar();

	bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
	viewStatusBar->setChecked(bViewStatusbar);
	slotViewStatusBar();

	// bar position settings
	KToolBar::BarPosition toolBarPos;
	toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos", KToolBar::Top);
	toolBar("mainToolBar")->setBarPos(toolBarPos);
	
	QSize size=config->readSizeEntry("Geometry");
	if(!size.isEmpty())
	{
		resize(size);
	}
	
	// Restore the last emulator and game selected
	emulatorString = config->readEntry("Emulator",0);
	int index = config->readNumEntry("Last Game Index",0);
	if (emulatorString == "Mess apple2c") slotEmulatorMess_apple2c();
	if (emulatorString == "Mess apple2e") slotEmulatorMess_apple2e();
	if (emulatorString == "Stella") slotEmulatorStella();
	if (emulatorString == "Dega Master System") slotEmulatorDega_sms();
	if (emulatorString == "Dega Game Gear") slotEmulatorDega_gg();
	if (emulatorString == "Dgen") slotEmulatorDgen();
	if (emulatorString == "Mess a5200") slotEmulatorMess_a5200();
	if (emulatorString == "Mess a7800") slotEmulatorMess_a7800();
	if (emulatorString == "Mess coleco") slotEmulatorMess_coleco();
	if (emulatorString == "Mess genesis") slotEmulatorMess_genesis();
	if (emulatorString == "Mess nes") slotEmulatorMess_nes();
	if (emulatorString == "Mess nespal") slotEmulatorMess_nespal();
	if (emulatorString == "Mess sms") slotEmulatorMess_sms();
	if (emulatorString == "Mess gg") slotEmulatorMess_gg();
	if (emulatorString == "Snes9x") slotEmulatorSnes9x();
	if (emulatorString == "Fce") slotEmulatorFce();
	if (emulatorString == "Mess ti99_4a") slotEmulatorMess_ti99_4a();
	if (emulatorString == "Mess vectrex") slotEmulatorMess_vectrex();
	kemulatorWidget->setCurrentItem(index);
}

bool KemulatorApp::queryExit()
{
	saveOptions();
	return true;
}

void KemulatorApp::deleteEmulator()
{
	if (mess != 0) 
	{
		delete mess;
		emulator = 0;
		mess = 0;
	}

	if (snes9x != 0) 
	{
		delete snes9x;
		emulator = 0;
		snes9x = 0;
	}

	if (fce != 0)
	{
		delete fce;
		emulator = 0;
		fce = 0;
	}

	if (stella != 0) 
	{
		delete stella;
		emulator = 0;
		stella = 0;
	}

	if (dega != 0)
	{
		delete dega;
		emulator = 0;
		dega = 0;
	}

	if (dgen != 0)
	{
		delete dgen;
		emulator = 0;
		dgen = 0;
	}
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void KemulatorApp::slotFilePlay()
{
	slotStatusMsg(i18n("Play..."));
	int index = kemulatorWidget->currentItem();
	if (index != 0) emulator->emulate(index);
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotFileRandom()
{
	slotStatusMsg(i18n("Selecting..."));
	kemulatorWidget->random();
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotFileQuit()
{
	slotStatusMsg(i18n("Exiting..."));
	saveOptions();
	slotStatusMsg(i18n("Ready."));
	close();
}

void KemulatorApp::slotEmulatorMess_apple2c()
{
	slotStatusMsg(i18n("Loading..."));
	deleteEmulator();
	mess = new Mess("apple2c");
	emulator = mess;
	kemulatorWidget->insertStringList(emulator->romList());
	emulatorString = "Mess apple2c";
	this->setCaption(emulatorString);
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotEmulatorMess_apple2e()
{
	slotStatusMsg(i18n("Loading..."));
	deleteEmulator();
	mess = new Mess("apple2e");
	emulator = mess;
	kemulatorWidget->insertStringList(emulator->romList());
	emulatorString = "Mess apple2e";
	this->setCaption(emulatorString);
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotEmulatorStella()
{
	slotStatusMsg(i18n("Loading..."));
	deleteEmulator();
	stella = new Stella();
	emulator = stella;
	kemulatorWidget->insertStringList(emulator->romList());
	emulatorString = "Stella";
	this->setCaption(emulatorString);
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotEmulatorDega_sms()
{
	slotStatusMsg(i18n("Loading..."));
	deleteEmulator();
	dega = new Dega("sms");
	emulator = dega;
	kemulatorWidget->insertStringList(emulator->romList());
	emulatorString = "Dega Master System";
	this->setCaption(emulatorString);
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotEmulatorDega_gg()
{
	slotStatusMsg(i18n("Loading..."));
	deleteEmulator();
	dega = new Dega("gg");
	emulator = dega;
	kemulatorWidget->insertStringList(emulator->romList());
	emulatorString = "Dega Game Gear";
	this->setCaption(emulatorString);
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotEmulatorDgen()
{
	slotStatusMsg(i18n("Loading..."));
	deleteEmulator();
	dgen = new Dgen();
	emulator = dgen;
	kemulatorWidget->insertStringList(emulator->romList());
	emulatorString = "Dgen";
	this->setCaption(emulatorString);
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotEmulatorMess_a5200()
{
	slotStatusMsg(i18n("Loading..."));
	deleteEmulator();
	mess = new Mess("a5200");
	emulator = mess;
	kemulatorWidget->insertStringList(emulator->romList());
	emulatorString = "Mess a5200";
	this->setCaption(emulatorString);
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotEmulatorMess_a7800()
{
	slotStatusMsg(i18n("Loading..."));
	deleteEmulator();
	mess = new Mess("a7800");
	emulator = mess;
	kemulatorWidget->insertStringList(emulator->romList());
	emulatorString = "Mess a7800";
	this->setCaption(emulatorString);
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotEmulatorMess_coleco()
{
	slotStatusMsg(i18n("Loading..."));
	deleteEmulator();
	mess = new Mess("coleco");
	emulator = mess;
	kemulatorWidget->insertStringList(emulator->romList());
	emulatorString = "Mess coleco";
	this->setCaption(emulatorString);
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotEmulatorMess_genesis()
{
	slotStatusMsg(i18n("Loading..."));
	deleteEmulator();
	mess = new Mess("genesis");
	emulator = mess;
	kemulatorWidget->insertStringList(emulator->romList());
	emulatorString = "Mess genesis";
	this->setCaption(emulatorString);
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotEmulatorMess_intv()
{
	slotStatusMsg(i18n("Loading..."));
	deleteEmulator();
	mess = new Mess("intv");
	emulator = mess;
	kemulatorWidget->insertStringList(emulator->romList());
	emulatorString = "Mess intv";
	this->setCaption(emulatorString);
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotEmulatorMess_nes()
{
	slotStatusMsg(i18n("Loading..."));
	deleteEmulator();
	mess = new Mess("nes");
	emulator = mess;
	kemulatorWidget->insertStringList(emulator->romList());
	emulatorString = "Mess nes";
	this->setCaption(emulatorString);
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotEmulatorMess_nespal()
{
	slotStatusMsg(i18n("Loading..."));
	deleteEmulator();
	mess = new Mess("nespal");
	emulator = mess;
	kemulatorWidget->insertStringList(emulator->romList());
	emulatorString = "Mess nespal";
	this->setCaption(emulatorString);
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotEmulatorMess_sms()
{
	slotStatusMsg(i18n("Loading..."));
	deleteEmulator();
	mess = new Mess("sms");
	emulator = mess;
	kemulatorWidget->insertStringList(emulator->romList());
	emulatorString = "Mess sms";
	this->setCaption(emulatorString);
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotEmulatorMess_gg()
{
	slotStatusMsg(i18n("Loading..."));
	deleteEmulator();
	mess = new Mess("gamegear");
	emulator = mess;
	kemulatorWidget->insertStringList(emulator->romList());
	emulatorString = "Mess gg";
	this->setCaption(emulatorString);
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotEmulatorSnes9x()
{
	slotStatusMsg(i18n("Loading..."));
	deleteEmulator();
	snes9x = new Snes9x();
	emulator = snes9x;
	kemulatorWidget->insertStringList(emulator->romList());
	emulatorString = "Snes9x";
	this->setCaption(emulatorString);
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotEmulatorFce()
{
	slotStatusMsg(i18n("Loading..."));
	deleteEmulator();
	fce = new Fce();
	emulator = fce;
	kemulatorWidget->insertStringList(emulator->romList());
	emulatorString = "Fce";
	this->setCaption(emulatorString);
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotEmulatorMess_ti99_4a()
{
	slotStatusMsg(i18n("Loading..."));
	deleteEmulator();
	mess = new Mess("ti99_4a");
	emulator = mess;
	kemulatorWidget->insertStringList(emulator->romList());
	emulatorString = "Mess ti99_4a";
	this->setCaption(emulatorString);
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotEmulatorMess_vectrex()
{
	slotStatusMsg(i18n("Loading..."));
	deleteEmulator();
	mess = new Mess("vectrex");
	emulator = mess;
	kemulatorWidget->insertStringList(emulator->romList());
	emulatorString = "Mess vectrex";
	this->setCaption(emulatorString);
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotEmulatorConfigure()
{
	slotStatusMsg(i18n("Configure..."));

	if (emulator == 0)
	{
		QMessageBox::warning(this, i18n("Configuration..."),
		                     i18n("Please select an emulator."));
	}
	else
	{
		int index = kemulatorWidget->currentItem();
		if (typeid(*emulator) == typeid(Mess))
		{
			MessDlgImpl messDlgImpl(mess->system(), this, "messDlgImpl", true);
			messDlgImpl.exec();
			// Reload the configuration if saved
			if (messDlgImpl.result() != QDialog::Rejected) slotEmulatorRefresh();
		}

		if (typeid(*emulator) == typeid(Snes9x))
		{
			Snes9xDlgImpl snes9xDlgImpl(this, "snes9xDlgImpl", true);
			snes9xDlgImpl.exec();
			// Reload the configuration if saved
			if (snes9xDlgImpl.result() != QDialog::Rejected) slotEmulatorRefresh();
		}

		if (typeid(*emulator) == typeid(Fce))
		{
			FceDlgImpl fceDlgImpl(this, "fceDlgImpl", true);
			fceDlgImpl.exec();
			// Reload the configuration if saved
			if (fceDlgImpl.result() != QDialog::Rejected) slotEmulatorRefresh();
		}

		if (typeid(*emulator) == typeid(Stella))
		{
			StellaDlgImpl stellaDlgImpl(this, "stellaDlgImpl", true);
			stellaDlgImpl.exec();
			// Reload the configuration if saved
			if (stellaDlgImpl.result() != QDialog::Rejected) slotEmulatorRefresh();
		}

		if (typeid(*emulator) == typeid(Dega))
		{
			DegaDlgImpl degaDlgImpl(dega->system(), this, "degaDlgImpl", true);
			degaDlgImpl.exec();

			// Reload the configuration if saved
			if (degaDlgImpl.result() != QDialog::Rejected) slotEmulatorRefresh();
		}

		if (typeid(*emulator) == typeid(Dgen))
		{
			DgenDlgImpl dgenDlgImpl(this, "dgenDlgImpl", true);
			dgenDlgImpl.exec();

			// Reload the configuration if saved
			if (dgenDlgImpl.result() != QDialog::Rejected) slotEmulatorRefresh();
		}
		kemulatorWidget->setCurrentItem(index);
	}

	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotEmulatorRefresh()
{
	slotStatusMsg(i18n("Loading..."));
	if (emulator != 0) 
	{
		emulator->refresh();
		kemulatorWidget->insertStringList(emulator->romList());
	}
	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotViewToolBar()
{
	slotStatusMsg(i18n("Toggling toolbar..."));

	///////////////////////////////////////////////////////////////////
	// turn Toolbar on or off
	if(!viewToolBar->isChecked())
	{
		toolBar("mainToolBar")->hide();
	}
	else
	{
		toolBar("mainToolBar")->show();
	}		

	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotViewStatusBar()
{
	slotStatusMsg(i18n("Toggle the statusbar..."));

	///////////////////////////////////////////////////////////////////
	//turn Statusbar on or off
	if(!viewStatusBar->isChecked())
	{
		statusBar()->hide();
	}
	else
	{
		statusBar()->show();
	}

	slotStatusMsg(i18n("Ready."));
}

void KemulatorApp::slotStatusMsg(const QString &text)
{
	// change status message permanently
	statusBar()->clear();
	statusBar()->changeItem(text, ID_STATUS_MSG);
}

void KemulatorApp::slotSelected(int index)
{
	emulator->emulate(index);
}
