/***************************************************************************
                          mess.h  -  MESS emulator settings
                             -------------------
    begin                : Wed Sep 19 09:43:31 EDT 2001
    copyright            : (C) 2001 by Scott L. Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MESS_H
#define MESS_H

#include "emulator.h"
#include <qstring.h>

class Mess : public Emulator
{ 
public:
	/** Constructor */
	Mess(const QString &system);
	/** Destructor */
	~Mess() {};

	/** recreate the romlist */
	virtual void refresh();

	/** load the emulator settings */
	virtual void load();
	/** save the emulator settings */
	virtual void save();

	/** run the emulator */
	virtual void emulate(int);

	/** returns the default executable */
	virtual QString defaultExecutable() const { return "xmess.SDL"; }
	/** returns the default ROM directory */
	virtual QString defaultRomDir() const;

	// Audio
	/** set the dsp_plugin */
	void setDsp_plugin(const QString &dsp_plugin) { _dsp_plugin = dsp_plugin; }
	/** set the timer */
	void setTimer(bool timer) { _timer = timer; }
	/** set the sound_mixer_plugin */
	void setSound_mixer_plugin(const QString &sound_mixer_plugin) { _sound_mixer_plugin = sound_mixer_plugin; }
	/** set the sound */
	void setSound(bool sound) { _sound = sound; }
	/** set the samples */
	void setSamples(bool samples) { _samples = samples; }
	/** set the fakesound */
	void setFakesound(bool fakesound) { _fakesound = fakesound; }
	/** set the samplefreq */
	void setSamplefreq(int samplefreq) { _samplefreq = samplefreq; }
	/** set the bufsize */
	void setBufsize(int bufsize) { _bufsize = bufsize; }
	/** set the volume */
	void setVolume(int volume) { _volume = volume; }
	/** set the audiodevice */
	void setAudiodevice(const QString &audiodevice) { _audiodevice = audiodevice; }
	/** set the mixerdevice */
	void setMixerdevice(const QString &mixerdevice) { _mixerdevice = mixerdevice; }

	// Input
	/** set the joytype */
	void setJoytype(int joytype) { _joytype = joytype; }
	/** set the analogstick */
	void setAnalogstick(bool analogstick) { _analogstick = analogstick; }
	/** set the joydevname */
	void setJoydevname(const QString &joydevname) { _joydevname = joydevname; }
	/** set the mouse */
	void setMouse(bool mouse) { _mouse = mouse; }
	/** set the hotrod */
	void setHotrod(bool hotrod) { _hotrod = hotrod; }
	/** set the hotrodse */
	void setHotrodse(bool hotrodse) { _hotrodse = hotrodse; }

	// Video
	/** set the bpp */
	void setBpp(int bpp) { _bpp = bpp; }
	/** set the heightscale */
	void setHeightscale(int heightscale) { _heightscale = heightscale; }
	/** set the widthscale */
	void setWidthscale(int widthscale) { _widthscale = widthscale; }
	/** set the scale */
	void setScale(int scale) { _scale = scale; }
	/** set the autodouble */
	void setAutodouble(bool autodouble) { _autodouble = autodouble; }
	/** set the dirty */
	void setDirty(bool dirty) { _dirty = dirty; }
	/** set the scanlines */
	void setScanlines(bool scanlines) { _scanlines = scanlines; }
	/** set the artwork */
	void setArtwork(bool artwork) { _artwork = artwork; }
	/** set the frameskipper */
	void setFrameskipper(int frameskipper) { _frameskipper = frameskipper; }
	/** set the throttle */
	void setThrottle(bool throttle) { _throttle = throttle; }
	/** set the sleepidle */
	void setSleepidle(bool sleepidle) { _sleepidle = sleepidle; }
	/** set the autoframeskip */
	void setAutoframeskip(bool autoframeskip) { _autoframeskip = autoframeskip; }
	/** set the maxautoframeskip */
	void setMaxautoframeskip(int maxautoframeskip) { _maxautoframeskip = maxautoframeskip; }
	/** set the frameskip */
	void setFrameskip(int frameskip) { _frameskip = frameskip; }
	/** set the brightness */
	void setBrightness(int brightness) { _brightness = brightness; }
	/** set the gamma_correction */
	void setGamma_correction(float gamma_correction) { _gamma_correction = gamma_correction; }
	/** set the norotate */
	void setNorotate(bool norotate) { _norotate = norotate; }
	/** set the ror */
	void setRor(bool ror) { _ror = ror; }
	/** set the rol */
	void setRol(bool rol) { _rol = rol; }
	/** set the flipx */
	void setFlipx(bool flipx) { _flipx = flipx; }
	/** set the flipy */
	void setFlipy(bool flipy) { _flipy = flipy; }
	/** set the fullscreen */
	void setFullscreen(bool fullscreen) { _fullscreen = fullscreen; }

	/** returns the dsp_plugin */
	QString dsp_plugin() const { return _dsp_plugin; }
	/** returns the timer */
	bool timer() const { return _timer; }
	/** returns the sound_mixer_plugin */
	QString sound_mixer_plugin() const { return _sound_mixer_plugin; }
	/** returns the sound */
	bool sound() const { return _sound; }
	/** returns the samples */
	bool samples() const { return _samples; }
	/** returns the fakesound */
	bool fakesound() const { return _fakesound; }
	/** returns the samplefreq */
	int samplefreq() const { return _samplefreq; }
	/** returns the bufsize */
	int bufsize() const { return _bufsize; }
	/** returns the volume */
	int volume() const { return _volume; }
	/** returns the audiodevice */
	QString audiodevice() const { return _audiodevice; }
	/** returns the mixerdevice */
	QString mixerdevice() const { return _mixerdevice; }

	/** returns the joytype */
	int joytype() const { return _joytype; }
	/** returns the analogstick */
	bool analogstick() const { return _analogstick; }
	/** returns the joydevname */
	QString joydevname() const { return _joydevname; }
	/** returns the mouse */
	bool mouse() const { return _mouse; }
	/** returns the hotrod */
	bool hotrod() const { return _hotrod; }
	/** returns the hotrodse */
	bool hotrodse() const { return _hotrodse; }

	/** returns the bpp */
	int bpp() const { return _bpp; }
	/** returns the heightscale */
	int heightscale() const { return _heightscale; }
	/** returns the widthscale */
	int widthscale() const { return _widthscale; }
	/** returns the scale */
	float scale() const { return _scale; }
	/** returns the autodouble */
	bool autodouble() const { return _autodouble; }
	/** returns the dirty */
	bool dirty() const { return _dirty; }
	/** returns the scanlines */
	bool scanlines() const { return _scanlines; }
	/** returns the artwork */
	bool artwork() const { return _artwork; }
	/** returns the frameskipper */
	int frameskipper() const { return _frameskipper; }
	/** returns the throttle */
	bool throttle() const { return _throttle; }
	/** returns the sleepidle */
	bool sleepidle() const { return _sleepidle; }
	/** returns the autoframeskip */
	bool autoframeskip() const { return _autoframeskip; }
	/** returns the maxautoframeskip */
	int maxautoframeskip() const { return _maxautoframeskip; }
	/** returns the frameskip */
	int frameskip() const { return _frameskip; }
	/** returns the brightness */
	int brightness() const { return _brightness; }
	/** returns the gamma_correction */
	float gamma_correction() const { return _gamma_correction; }
	/** returns the norotate */
	bool norotate() const { return _norotate; }
	/** returns the ror */
	bool ror() const { return _ror; }
	/** returns the rol */
	bool rol() const { return _rol; }
	/** returns the flipx */
	bool flipx() const { return _flipx; }
	/** returns the flipy */
	bool flipy() const { return _flipy; }
	/** returns the fullscreen */
	bool fullscreen() const { return _fullscreen; }

	/** returns the dsp_plugin */
	QString defaultDsp_plugin() const { return 0; }
	/** returns the timer */
	bool defaultTimer() const { return true; }
	/** returns the sound_mixer_plugin */
	QString defaultSound_mixer_plugin() const { return 0; }
	/** returns the sound */
	bool defaultSound() const { return true; }
	/** returns the samples */
	bool defaultSamples() const { return true; }
	/** returns the fakesound */
	bool defaultFakesound() const { return false; }
	/** returns the samplefreq */
	int defaultSamplefreq() const { return 44000; }
	/** returns the bufsize */
	int defaultBufsize() const { return 10; }
	/** returns the volume */
	int defaultVolume() const { return -3; }
	/** returns the audiodevice */
	QString defaultAudiodevice() const { return 0; }
	/** returns the mixerdevice */
	QString defaultMixerdevice() const { return 0; }

	/** returns the default joytype */
	int defaultJoytype() const { return 1; }
	/** returns the default analogstick */
	bool defaultAnalogstick() const { return false; }
	/** returns the default joydevname */
	QString defaultJoydevname() const { return 0; }
	/** returns the default mouse */
	bool defaultMouse() const { return true; }
	/** returns the default hotrod */
	bool defaultHotrod() const { return false; }
	/** returns the default hotrodse */
	bool defaultHotrodse() const { return false; }

	/** returns the default bpp */
	int defaultBpp() const { return 0; }
	/** returns the default heightscale */
	int defaultHeightscale() const { return 1; }
	/** returns the default widthscale */
	int defaultWidthscale() const { return 1; }
	/** returns the default scale */
	float defaultScale() const { return 1; }
	/** returns the default autodouble */
	bool defaultAutodouble() const { return true; }
	/** returns the default dirty */
	bool defaultDirty() const { return false; }
	/** returns the default scanlines */
	bool defaultScanlines() const { return false; }
	/** returns the default artwork */
	bool defaultArtwork() const { return true; }
	/** returns the default frameskipper */
	bool defaultFrameskipper() const { return 1; }
	/** returns the default throttle */
	bool defaultThrottle() const { return true; }
	/** returns the default sleepidle */
	bool defaultSleepidle() const { return true; }
	/** returns the default autoframeskip */
	bool defaultAutoframeskip() const { return true; }
	/** returns the default maxautoframeskip */
	int defaultMaxautoframeskip() const { return 5; }
	/** returns the default frameskip */
	int defaultFrameskip() const { return 5; }
	/** returns the default brightness */
	int defaultBrightness() const { return 100; }
	/** returns the default gamma_correction */
	float defaultGamma_correction() const { return 0; }
	/** returns the default norotate */
	bool defaultNorotate() const { return true; }
	/** returns the default ror */
	bool defaultRor() const { return false; }
	/** returns the default rol */
	bool defaultRol() const { return false; }
	/** returns the default flipx */
	bool defaultFlipx() const { return false; }
	/** returns the default flipy */
	bool defaultFlipy() const { return false; }
	/** returns the default fullscreen */
	bool defaultFullscreen() const { return true; }

	/** returns the system setting */
	QString system() const { return _system; }

protected:
	/** What system is MESS emulating */
	QString _system;

	/*** Digital sound related ***/
	/** Select which plugin to use for digital sound */
	QString _dsp_plugin;
	/** List available sound-dsp plugins */
	bool _list_dsp_plugins;
	/** Use / don't use timer based audio (normally it will be used automagicly when nescesarry) */
	bool _timer;

	/*** Sound mixer related ***/
	/** Select which plugin to use for the sound mixer */
	QString _sound_mixer_plugin;
	/** List available sound-mixer plugins */
	bool _list_mixer_plugins;

	/*** Video Related ***/
	/** Specify the colordepth the core should render, one of: auto(0), 8, 16 */
	int _bpp;                                          
	/** Set Y-Scale aspect ratio */
	int _heightscale;                               
	/** Set X-Scale aspect ratio */
	int _widthscale;                                
	/** Set X-Y Scale to the same aspect ratio. For vector games scale (and also width- and heightscale) 
	 * may have value's like 1.5 and even 0.5. For scaling of regular games this will be rounded to an int
	 */
	float _scale;                                             
	/** Enable/disable automatic scale doubling for 1:2 pixel aspect ratio games */
	bool _autodouble;
	/** Enable/disable use of dirty rectangles */
	bool _dirty;                     
	/** Enable/disable displaying simulated scanlines */
	bool _scanlines;          
	/** Use/don't use artwork if available */
	bool _artwork;                        
	/** Select which autoframeskip and throttle routines to use. Available choices are:
	 * 0 = Dos frameskip code
	 * 1 = Enhanced frameskip code by William A. Barath
	 */
	int _frameskipper;              
	/** Enable/disable throttle */
	bool _throttle;                                 
	/** Enable/disable sleep during idle */
	bool _sleepidle;                       
	/** Enable/disable autoframeskip */
	bool _autoframeskip;                      
	/** Set highest allowed frameskip for autoframeskip */
	int _maxautoframeskip;
	/** Set frameskip when not using autoframeskip */
	int _frameskip;               
	/** Set the brightness (0-100%%) */
	int _brightness;                           
	/** Set the gamma-correction (0.5-2.0) */
	float _gamma_correction;                      
	/** Disable rotation */
	bool _norotate;                                                
	/** Rotate display 90 degrees rigth */
	bool _ror;                                      
	/** Rotate display 90 degrees left */
	bool _rol;                                       
	/** Flip X axis */
	bool _flipx;                                                        
	/** Flip Y axis */
	bool _flipy;                                                        

	/*** Vector Games Related ***/
	/** Always scale vectorgames to XresxYres, keeping their aspect ratio. This overrides the scale options */                            
	QString _vectorres;
	/** Set the beam size for vector games */
	float _beam;
	/** Set the flicker for vector games */
	float _flicker;
	/** Enable/disable antialiasing */
	bool _antialias;
	/** Enable/disable tranlucency */
	bool _translucency;
                      
	/*** SDL Related ***/
	/** List all posible full-screen modes */
	bool _listmodes;
	/** Start fullscreen */
	bool _fullscreen;
	/** Try to use the 'n' possible full-screen mode */
	int _modenumber;
	/** Set a specific key mapping, see xmamerc.dist */
	QString _sdlmapkey;

	/*** Sound Related ***/
	/** Enable/disable sound (if available) */
	bool _sound;
	/** Use/don't use samples (if available) */
	bool _samples;
	/** Generate sound even when sound is disabled, this is needed for some games which won't run without sound */                          
	bool _fakesound;
	/** Set the playback sample-frequency/rate */
	int _samplefreq;
	/** Number of frames of sound to buffer */
	int _bufsize;
	/** Set volume to <int> db, (-32 (soft) - 0(loud)) */
	int _volume;
	/** Use an alternative audiodevice */
	QString _audiodevice;
	/** Use an alternative mixerdevice */
	QString _mixerdevice;

	/*** Input Related ***/
	/** Select type of joystick support to use:
	 * 0 = No joystick
	 * 1 = i386 style joystick driver
	 * 2 = Fm Town pad support
	 * 3 = X11 input extension joystick
	 * 4 = new i386 linux 1.x.x joystick driver
	 * 5 = NetBSD USB joystick driver
	 */
	int _joytype;
	/** Use Joystick as analog for analog controls */
	bool _analogstick;
	/** Joystick device prefix (defaults to /dev/js) */
	QString _joydevname;
	/** Enable/disable mouse (if supported) */
	bool _mouse;
	/** Enable HotRod joystick support */
	bool _hotrod;                  
	/** Select HotRod SE joystick support */
	bool _hotrodse;

	/*** Fileio Related ***/
	/** Set the rom search path */
	QString _rompath;                                 
	/** Set highscore spooldir */
	QString _spooldir;                                 
	/** Set dir to store screenshots in */
	QString _screenshotdir;                  
	/** Set dir to look for cheat files in */
	QString _cheatdir;                           
	/** Set dir to look for crc files in */
	QString _crcdir;                               
	/** Set the file to use as cheat database */
	QString _cheatfile;                 
	/** Set the file to use as high score database */
	QString _hiscorefile;
	/** Set the file to use as history database */
	QString _historyfile;             
	/** Set the file to use as mameinfo database */
	QString _mameinfofile;           
	/** Set a file to record keypresses into */
	QString _record;
	/** Set a file to playback keypresses from */
	QString _playback;                    
	/** Set a file to redirect stderr to */
	QString _stdout_file;                 
	/** Set a file to redirect stdout to */
	QString _stderr_file;                 
	/** Set a file to log debug info to */
	QString _log;                            

	/*** Mess Related ***/
	/** All following images are seen as cartridges/roms */
	bool _cartridge;
	/** All following images are seen as floppies */
	bool _floppydisk;            
	/** All following images are seen as hard disks */
	bool _harddisk;                   
	/** All following images are seen as cylinders */
	bool _cylinder;                    
	/** All following images are seen as cassettes */
	bool _cassette;                    
	/** All following images are seen as punchcards */
	bool _punchcard;
	/** All following images are seen as punchtapes */
	bool _punchtape;                  
	/** All following images are seen as printers */
	bool _printer;                      
	/** All following images are seen as serial ports */
	bool _serial;                   
	/** All following images are seen as parallel ports */
	bool _parallel;               
	/** All following images are seen as snapshots */
	bool _snapshot;                    
	/** All following images are seen as quickload images */
	bool _quickload;             
	/** Select the language for the menus and osd */
	QString _language;            
	/** Enable/disable use of fuzzy gamename matching when there is no exact match */
	bool _fuzzycmp;                            
	/** Enable/disable cheat subsystem */
	bool _cheat;
};

#endif // MESS_H
