/***************************************************************************
                          snes9x.cpp  -  Snes9x emulator
                             -------------------
    begin                : Fri Nov  2 20:09:20 EST 2001
    copyright            : (C) 2001 by Scott L. Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "snes9x.h"
#include <qdir.h>
#include <qfileinfo.h>
#include <iostream.h>
#include <kprocess.h>

Snes9x::Snes9x() : Emulator()
{
	refresh();
}

void Snes9x::refresh()
{
	Emulator::refresh();
	load();
	setRomList();
}

void Snes9x::load()
{
	config->setGroup("Snes9x");
	Emulator::load();

	// Audio
	setSound(config->readBoolEntry("Sound", defaultSound()));
	setStereo(config->readBoolEntry("Stereo", defaultStereo()));
	setSoundquality(config->readNumEntry("Sound Quality", defaultSoundquality()));
	setBuffersize(config->readNumEntry("Buffer Size", defaultBuffersize()));
	setEcho(config->readBoolEntry("Echo", defaultEcho()));
	setEnvx(config->readBoolEntry("Envx", defaultEnvx()));
	setSamplecaching(config->readBoolEntry("Sample Caching", defaultSamplecaching()));
	setMastervolume(config->readBoolEntry("Master Volume", defaultMastervolume()));
	setSoundsync(config->readBoolEntry("Sound Sync", defaultSoundsync()));
	setSoundsync2(config->readBoolEntry("Sound Sync2", defaultSoundsync2()));
	setInterpolatedsound(config->readBoolEntry("Interpolated Sound", defaultInterpolatedsound()));
	setThreadsound(config->readBoolEntry("Threaded Sound", defaultThreadsound()));
	setAltsampledecode(config->readBoolEntry("Alt Sample Decode", defaultAltsampledecode()));

	// Cheat
	setGamegenie(config->readEntry("Gamegenie Code", defaultGamegenie()));
	setActionreplay(config->readEntry("Actionreplay Code", defaultActionreplay()));
	setGoldfinger(config->readEntry("Goldfinger Code", defaultGoldfinger()));

	// Input
	setMouse(config->readBoolEntry("Mouse", defaultMouse()));
	setSuperscope(config->readBoolEntry("Superscope", defaultSuperscope()));
	setJoy(config->readBoolEntry("Joystick", defaultJoy()));
	setSwapjoypads(config->readBoolEntry("Swap Joypads", defaultSwapjoypads()));
	setJoydev1(config->readEntry("Joystick Device 1", defaultJoydev1()));
	setJoydev2(config->readEntry("Joystick Device 2", defaultJoydev2()));
	setJoymap1(config->readEntry("Joystick Map 1", defaultJoymap1()));
	setJoymap2(config->readEntry("Joystick Map 2", defaultJoymap2()));

	// Netplay
	setMultiplayer5(config->readBoolEntry("Multiplayer TAP", defaultMultiplayer5()));
	setNet(config->readBoolEntry("Netplay", defaultNet()));
	setServer(config->readEntry("Server", defaultServer()));
	setPort(config->readNumEntry("Port", defaultPort()));

	// ROM
	setInterleaved(config->readBoolEntry("Interleaved", defaultInterleaved()));
	setInterleaved2(config->readBoolEntry("Interleaved2", defaultInterleaved2()));
	setHirom(config->readBoolEntry("Hi-ROM", defaultHirom()));
	setLorom(config->readBoolEntry("Lo-ROM", defaultLorom()));
	setHeader(config->readBoolEntry("Header", defaultHeader()));
	setNoheader(config->readBoolEntry("No Header", defaultNoheader()));
	setPal(config->readBoolEntry("PAL", defaultPal()));
	setNtsc(config->readBoolEntry("NTSC", defaultNtsc()));
	setLayering(config->readBoolEntry("Layering", defaultLayering()));
	setLoadsnapshot(config->readEntry("Load Snapshot", defaultLoadsnapshot()));
	setHdma(config->readBoolEntry("H-DMA", defaultHdma()));
	setSpeedhacks(config->readBoolEntry("Speed Hacks", defaultSpeedhacks()));
	setWindows(config->readBoolEntry("Windows", defaultWindows()));

	// Video
	setTransparency(config->readBoolEntry("Transparency", defaultTransparency()));
	setSixteen(config->readBoolEntry("Sixteen", defaultSixteen()));
	setHires(config->readBoolEntry("Hires", defaultHires()));
	setInterpolate(config->readBoolEntry("Interpolate", defaultInterpolate()));
	setInterpolate2(config->readBoolEntry("Interpolate2", defaultInterpolate2()));
	setInterpolate3(config->readBoolEntry("Interpolate3", defaultInterpolate3()));
	setInterpolate4(config->readBoolEntry("Interpolate4", defaultInterpolate4()));
	setInterpolate5(config->readBoolEntry("Interpolate5", defaultInterpolate5()));
	setModeswitch(config->readBoolEntry("Mode Switch", defaultModeswitch()));
	setFullscreen(config->readBoolEntry("Fullscreen", defaultFullscreen()));
	setScale(config->readBoolEntry("Scale", defaultScale()));
	setDisplayframerate(config->readBoolEntry("Display Framerate", defaultDisplayframerate()));
	setFrameskip(config->readNumEntry("Frameskip", defaultFrameskip()));
	setFrametime(config->readNumEntry("Frametime", defaultFrametime()));
	setCycles(config->readNumEntry("CPU Cycles", defaultCycles()));
}

void Snes9x::save()
{
	config->setGroup("Snes9x");
	Emulator::save();

	// Audio
	config->writeEntry("Sound", sound());
	config->writeEntry("Stereo", stereo());
	config->writeEntry("Sound Quality", soundquality());
	config->writeEntry("Buffer Size", buffersize());
	config->writeEntry("Echo", echo());
	config->writeEntry("Envx", envx());
	config->writeEntry("Sample Caching", samplecaching());
	config->writeEntry("Master Volume", mastervolume());
	config->writeEntry("Sound Sync", soundsync());
	config->writeEntry("Sound Sync2", soundsync2());
	config->writeEntry("Interpolated Sound", interpolatedsound());
	config->writeEntry("Threaded Sound", threadsound());
	config->writeEntry("Alt Sample Decode", altsampledecode());

	// Cheat
	config->writeEntry("Gamegenie Code", gamegenie());
	config->writeEntry("Actionreplay Code", actionreplay());
	config->writeEntry("Goldfinger Code", goldfinger());

	// Input
	config->writeEntry("Mouse", mouse());
	config->writeEntry("Superscope", superscope());
	config->writeEntry("Joystick", joy());
	config->writeEntry("Swap Joypads", swapjoypads());
	config->writeEntry("Joystick Device 1", joydev1());
	config->writeEntry("Joystick Device 2", joydev2());
	config->writeEntry("Joystick Map 1", joymap1());
	config->writeEntry("Joystick Map 2", joymap2());

	// Netplay
	config->writeEntry("Multiplayer TAP", multiplayer5());
	config->writeEntry("Netplay", net());
	config->writeEntry("Server", server());
	config->writeEntry("Port", port());

	// ROM
	config->writeEntry("Interleaved", interleaved());
	config->writeEntry("Interleaved2", interleaved2());
	config->writeEntry("Hi-ROM", hirom());
	config->writeEntry("Lo-ROM", lorom());
	config->writeEntry("Header", header());
	config->writeEntry("No Header", noheader());
	config->writeEntry("PAL", pal());
	config->writeEntry("NTSC", ntsc());
	config->writeEntry("Layering", layering());
	config->writeEntry("Load Snapshot", loadsnapshot());
	config->writeEntry("H-DMA", hdma());
	config->writeEntry("Speed Hacks", speedhacks());
	config->writeEntry("Windows", windows());

	// Video
	config->writeEntry("Transparency", transparency());
	config->writeEntry("Sixteen", sixteen());
	config->writeEntry("Hires", hires());
	config->writeEntry("Interpolate", interpolate());
	config->writeEntry("Interpolate2", interpolate2());
	config->writeEntry("Interpolate3", interpolate3());
	config->writeEntry("Interpolate4", interpolate4());
	config->writeEntry("Interpolate5", interpolate5());
	config->writeEntry("Mode Switch", modeswitch());
	config->writeEntry("Fullscreen", fullscreen());
	config->writeEntry("Scale", scale());
	config->writeEntry("Display Framerate", displayframerate());
	config->writeEntry("Frameskip", frameskip());
	config->writeEntry("Frametime", frametime());
	config->writeEntry("CPU Cycles", cycles());
}

// TODO - Could probably optimize the arguments string creation
void Snes9x::emulate(int index)
{
	// Executable
	QString command;
	command.append(executable());
	command.append(" ");

	// Audio
	if (sound()) command.append("-sound "); else command.append("-nosound ");
	if (stereo()) command.append("-stereo "); else command.append("-mono ");
	command.append("-soundquality ");
	command.append(QString::number(soundquality()));
	command.append(" ");
	command.append("-buffersize ");
	command.append(QString::number(buffersize()));
	command.append(" ");
	if (echo()) command.append("-echo "); else command.append("-noecho ");
	if (envx()) command.append("-envx ");
	if (!samplecaching()) command.append("-nosamplecaching ");
	if (!mastervolume()) command.append("-nomastervolume ");
	if (soundsync()) command.append("-soundsync ");
	if (soundsync2()) command.append("-soundsync2 ");
	if (interpolatedsound()) command.append("-interpolatedsound ");
	if (threadsound()) command.append("-threadsound ");
	if (altsampledecode()) command.append("-altsampledecode ");

	// Cheat
	if (gamegenie().length() > 0)
	{
		command.append("-gamegenie ");
		command.append(gamegenie());
		command.append(" ");
	}
	if (actionreplay().length() > 0)
	{
		command.append("-actionreplay ");
		command.append(actionreplay());
		command.append(" ");
	}
	if (goldfinger().length() > 0)
	{
		command.append("-goldfinger ");
		command.append(goldfinger());
		command.append(" ");
	}

	// Input
	if (mouse()) command.append("-mouse ");
	if (superscope()) command.append("-superscope ");
	if (!joy()) command.append("-nojoy ");
	if (swapjoypads()) command.append("-swapjoypads ");
	if (joydev1().length() > 0)
	{
		command.append("-joydev1 ");
		command.append(joydev1());
		command.append(" ");
	}
	if (joydev2().length() > 0)
	{
		command.append("-joydev2 ");
		command.append(joydev2());
		command.append(" ");
	}
	if (joymap1().length() > 0)
	{
		command.append("-joymap1 ");
		command.append(joymap1());
		command.append(" ");
	}
	if (joymap2().length() > 0)
	{
		command.append("-joymap2 ");
		command.append(joymap2());
		command.append(" ");
	}

	// Netplay
	if (multiplayer5()) command.append("-multiplayer5 ");
	if (net()) 
	{
		command.append("-net ");
		if (server().length() > 0)
		{
			command.append("-server ");
			command.append(server());
			command.append(" ");
		}
		else
		{
			command.append("-server ");
			command.append("localhost");
			command.append(" ");
		}
		command.append("-port ");
		command.append(QString::number(port()));
		command.append(" ");
	}

	// ROM
	if (interleaved()) command.append("-interleaved ");
	if (interleaved2()) command.append("-interleaved2 ");
	if (hirom()) command.append("-hirom ");
	if (lorom()) command.append("-lorom ");
	if (header()) command.append("-header ");
	if (noheader()) command.append("-noheader ");
	if (pal()) command.append("-pal ");
	if (ntsc()) command.append("-ntsc ");
	if (layering()) command.append("-layering ");
	if (loadsnapshot().length() > 0)
	{
		command.append("-loadsnapshot \"");
		command.append(loadsnapshot());
		command.append("\" ");
	}
	if (!hdma()) command.append("-nohdma ");
	if (!speedhacks()) command.append("-nospeedhacks ");
	if (!windows()) command.append("-nowindows ");

	// Video
	if (transparency()) command.append("-transparency ");
	if (sixteen()) command.append("-sixteen ");
	if (hires()) command.append("-hires ");
	if (interpolate()) command.append("-y ");
	if (interpolate2()) command.append("-y2 ");
	if (interpolate3()) command.append("-y3 ");
	if (interpolate4()) command.append("-y4 ");
	if (interpolate5()) command.append("-y5 ");
	if (!modeswitch()) command.append("-nomodeswitch ");
	if (fullscreen()) command.append("-fullscreen ");
	if (scale()) command.append("-scale ");
	if (displayframerate()) command.append("-displayframerate ");
	if (frameskip() != -1)
	{
		command.append("-frameskip ");
		command.append(QString::number(frameskip()));
		command.append(" ");
	}
	if (frametime() != -1)
	{
		command.append("-frametime ");
		command.append(QString::number(frametime()));
		command.append(" ");
	}
	command.append("-cycles ");
	command.append(QString::number(cycles()));
	command.append(" ");

	// Full path to ROM
	QDir dir(_romDir);
	QFileInfo fileinfo(dir, _romList[index]);
	command.append("\"");
	command.append(fileinfo.filePath());
	command.append("\" ");

	// Run it
	command.append("& ");
	cout << command << endl;
	KShellProcess process;
	process << command;
	process.start(KProcess::DontCare, KProcess::NoCommunication);
}
