/***************************************************************************
                          dega.h  -  Dega emulator settings
                             -------------------
    begin                : Wed Sep 19 09:43:31 EDT 2001
    copyright            : (C) 2001 by Scott L. Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DEGA_H
#define DEGA_H

#include "emulator.h"
#include <qstring.h>

class Dega : public Emulator
{
public:
	/** Constructor */
	Dega(const QString &system);
	/** Destructor */
	~Dega() {};

	/** recreate the romlist */
	virtual void refresh();

	/** load the emulator settings */
	virtual void load();
	/** save the emulator settings */
	virtual void save();

	/** command to run the emulator */
	virtual void emulate(int);

	/** returns the default executable */
	virtual QString defaultExecutable() const { return "dega"; }
	/** returns the default ROM directory */
	virtual QString defaultRomDir() const { if(_system == "gg")return "/usr/local/games/gamegear/roms/"; return "/usr/local/games/mastersystem/roms"; }

	/** returns the machine type */
	int machineType() const { return _machineType; }
	/** returns whether to use pal display */
	bool usePal() const { return _usePal; }
	/** returns whether sound is to be enabled */
	bool enableSound() const { return _enableSound; }
	/** returns whether fullscreen mode should be enabled */
	bool fullscreen() const { return _fullscreen; }
	
	/** returns the machine type */
	int defaultMachineType() const { if(_system == "gg") return 1; return 2; }
	/** returns whether to use pal display */
	bool defaultUsePal() const { return false; }
	/** returns whether sound is to be enabled */
	bool defaultEnableSound() const { return true; }
	/** returns whether fullscreen mode should be enabled */
	bool defaultFullscreen() const { return false; }
	
	/** sets the machine type */
	void setMachineType(int type ) { _machineType = type; }
	/** sets whether to use pal display */
	void setUsePal(bool usePal ) { _usePal = usePal; }
	/** sets whether sound is to be enabled */
	void setEnableSound(bool enableSound) { _enableSound = enableSound; }
	/** sets whether fullscreen mode should be enabled */
	void setFullscreen(bool fullscreen) { _fullscreen = fullscreen; }

	/** returns the system setting */
	QString system() const { return _system; }

	
protected:
	/** What system is Dega emulating */
	QString _system;
	/** Use designated machine type 0 = autodetect, 1 = Game Gear, 2 = Master System */
	int _machineType;
	/** Indicates whether PAL or NTSC mode should be enabled */
	bool _usePal;
	/** Indicates whether sound is to be enabled */
	bool _enableSound;
	/** Indicates whether fullscreen mode should be enabled */
	bool _fullscreen;
};

#endif // DEGA_H
