/***************************************************************************
                          dgen.cpp  -  Dgen emulator
                             -------------------
    begin                : Tue Mar  6 20:01:53 EST 2001
    copyright            : (C) 2001 by Scott L. Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dgen.h"
#include <qdir.h>
#include <qfileinfo.h>
#include <iostream.h>
#include <kprocess.h>

Dgen::Dgen() : Emulator()
{
	refresh();
}

void Dgen::refresh()
{
	Emulator::refresh();
	load();
	setRomList();
}

void Dgen::load()
{
	config->setGroup("Dgen");
	Emulator::load();
	setUsePal(config->readBoolEntry("Use PAL", defaultUsePal()));
	setEnableJoystick(config->readBoolEntry("Joystick", defaultEnableJoystick()));
	setFullscreen(config->readBoolEntry("Fullscreen", defaultFullscreen()));
	setScale(config->readNumEntry("Scale", defaultScale()));
}

void Dgen::save()
{
	config->setGroup("Dgen");
	Emulator::save();
	config->writeEntry("Use PAL", usePal());
	config->writeEntry("Joystick", enableJoystick());
	config->writeEntry("Fullscreen", fullscreen());
	config->writeEntry("Scale", scale());
}

// TODO - Could probably optimize the arguments string creation
void Dgen::emulate(int index)
{
	// Executable
	QString command;
	command.append(executable());
	command.append(" ");

  if (usePal())
	{
		command.append("-P ");
	}

	if (enableJoystick())
	{
		command.append("-j ");
	}
	if (fullscreen())
	{
		command.append("-f ");
	}

	command.append("-S ");
	command.append(QString::number(scale()));
	command.append(" ");

	// Full path to ROM
	QDir dir(_romDir);
	QFileInfo fileinfo(dir, _romList[index]);
	command.append("\"");
	command.append(fileinfo.filePath());
	command.append("\" ");

	// Run it
	command.append("& ");
	cout << command << endl;
	KShellProcess process;
//	connect(process, SIGNAL(receivedStdout(KProcess *proc, char *buffer, int buflen)), this, SLOT(slotOutput(char *buffer)));
//	connect(process, SIGNAL(receivedStderr(KProcess *proc, char *buffer, int buflen)), this, SLOT(slotOutput(char *buffer)));
	process << command;
	process.start(KProcess::DontCare, KProcess::AllOutput);
}
