/***************************************************************************
                          dgen.h  -  Dgen emulator settings
                             -------------------
    begin                : Wed Sep 19 09:43:31 EDT 2001
    copyright            : (C) 2001 by Scott L. Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DGEN_H
#define DGEN_H

#include "emulator.h"
#include <qstring.h>

class Dgen : public Emulator
{
public:
	/** Constructor */
	Dgen();
	/** Destructor */
	~Dgen() {};

	/** recreate the romlist */
	virtual void refresh();

	/** load the emulator settings */
	virtual void load();
	/** save the emulator settings */
	virtual void save();

	/** command to run the emulator */
	virtual void emulate(int);

	/** returns the default executable */
	virtual QString defaultExecutable() const { return "dgen"; }
	/** returns the default ROM directory */
	virtual QString defaultRomDir() const { return "/usr/local/games/genesis/roms/"; }

	/** whether to enable joystick support */
	bool enableJoystick() const { return _joystick; }
	/** returns whether to use pal display */
	bool usePal() const { return _usePal; }
	/** returns the amount to scale the screen */
	int scale() const { return _scale; }
	/** returns whether fullscreen mode should be enabled */
	bool fullscreen() const { return _fullscreen; }
	
	/** returns whether to enable joystick support */
	bool defaultEnableJoystick() const { return false; }
	/** returns whether to use pal display */
	bool defaultUsePal() const { return false; }
	/** returns the amount to scale the screen */
	int defaultScale() const { return 1; }
	/** returns whether fullscreen mode should be enabled */
	bool defaultFullscreen() const { return false; }
	
	/** sets whether to enable joystick support */

	void setEnableJoystick(bool joystick ) { _joystick = joystick; }
	/** sets whether to use pal display */
	void setUsePal(bool usePal ) { _usePal = usePal; }
	/** sets the amount to scale the screen */
	void setScale(int scale) { _scale = scale; }
	/** sets whether fullscreen mode should be enabled */
	void setFullscreen(bool fullscreen) { _fullscreen = fullscreen; }
	
protected:
	/** Use designated machine type 0 = autodetect, 1 = Game Gear, 2 = Master System */
	bool _joystick;
	/** Indicates whether PAL or NTSC mode should be enabled */
	bool _usePal;
	/** Indicates the amount to scale the screen */
	int _scale;
	/** Indicates whether fullscreen mode should be enabled */
	bool _fullscreen;
};

#endif // DGEN_H
