/***************************************************************************
                          emulator.cpp  -  Base class for emulators
                             -------------------
    begin                : Wed Sep 19 09:38:33 EDT 2001
    copyright            : (C) 2001 by Scott L. Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "emulator.h"
#include <kapp.h>
#include <qdir.h>
#include <qfileinfo.h>
#include <iostream.h>

void Emulator::refresh()
{
	config=kapp->config();
}

void Emulator::load()
{
	setExecutable(config->readEntry("Executable", defaultExecutable()));
	setRomDir(config->readEntry("ROM Directory", defaultRomDir()));
}

void Emulator::save()
{
	config->writeEntry("Executable", executable());
	config->writeEntry("ROM Directory", romDir());
}

QString Emulator::executable() const
{
	return _executable;
}

QString Emulator::romDir() const
{
	return _romDir;
}

QStringList Emulator::romList() const
{
	return _romList;
}

void Emulator::setExecutable(const QString &executable)
{
	_executable = executable;
}

void Emulator::setRomDir(const QString &romDir)
{
	_romDir = romDir;
}

// Any files in the rom directory are assumed to be valid ROMs
void Emulator::setRomList()
{
	_romList.clear();
	QDir dir(_romDir);
	if (dir.exists())
	{
		dir.setFilter(QDir::Files);
		const QFileInfoList *list = dir.entryInfoList();
		QFileInfoListIterator iterator(*list);
		QFileInfo *fileinfo;
		QString string;
		while ((fileinfo = iterator.current()))
		{
			string = fileinfo->fileName().data();
			_romList.append(string);
			++iterator;
		}
		_romList.sort();
	}
}

