/***************************************************************************
                          fcedlgimpl.cpp  -  description
                             -------------------
    begin                : Sun Nov 18 22:07:24 EST 2001
    copyright            : (C) 2001 by Scott Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "fcedlgimpl.h"
#include "fce.h"
#include <qstring.h>
#include <kfiledialog.h>
#include <qfiledialog.h>
#include <qlabel.h>
#include <qtabwidget.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qcombobox.h>

FceDlgImpl::FceDlgImpl(QWidget *parent, const char *name, bool modal, WFlags fl) : FceDlg(parent, name, modal, fl) {
	_fce = new Fce();

	// Filesystem
	lineeditExecutable->setText(_fce->executable());
	lineeditRom->setText(_fce->romDir());

	// Audio
	checkboxSound->setChecked(_fce->sound());
	comboboxSoundquality->setCurrentItem(_fce->soundquality());
	comboboxBuffersize->setCurrentItem(_fce->buffersize());
	
	// Video
	checkboxPal->setChecked(_fce->pal());
	checkboxTvcolor->setChecked(_fce->tvcolor());
	spinboxFrameskip->setValue(_fce->frameskip());
	comboboxResolution->setCurrentItem(_fce->resolution());
}

FceDlgImpl::~FceDlgImpl(){
	delete _fce;
}

void FceDlgImpl::slotBrowseExecutable()
{
	QString string(KFileDialog::getOpenFileName(":"));
	if (!string.isNull()) lineeditExecutable->setText(string);
}

void FceDlgImpl::slotBrowseRom()
{
	QString string(KFileDialog::getExistingDirectory(":"));
	if (!string.isNull()) lineeditRom->setText(string);
}

void FceDlgImpl::slotDefaults()
{
	QString tabLabel = tabFce->tabLabel(tabFce->currentPage());

	if (tabLabel == "Filesystem")
	{
		lineeditExecutable->setText(_fce->defaultExecutable());
		lineeditRom->setText(_fce->defaultRomDir());
	}

	if (tabLabel == "Audio")
	{
		checkboxSound->setChecked(_fce->defaultSound());
		comboboxSoundquality->setCurrentItem(_fce->defaultSoundquality());
		comboboxBuffersize->setCurrentItem(_fce->defaultBuffersize());
	}

	if (tabLabel == "Video")
	{
		checkboxPal->setChecked(_fce->defaultPal());
		checkboxTvcolor->setChecked(_fce->defaultTvcolor());
		spinboxFrameskip->setValue(_fce->defaultFrameskip());
		comboboxResolution->setCurrentItem(_fce->defaultResolution());
	}
}

void FceDlgImpl::slotSave()
{
	// Filesystem
	_fce->setExecutable(lineeditExecutable->text());
	_fce->setRomDir(lineeditRom->text());

	// Audio
	_fce->setSound(checkboxSound->isChecked());
	_fce->setSoundquality(comboboxSoundquality->currentItem());
	_fce->setBuffersize(comboboxBuffersize->currentItem());
	
	// Video
	_fce->setPal(checkboxPal->isChecked());
	_fce->setTvcolor(checkboxTvcolor->isChecked());
	_fce->setFrameskip(spinboxFrameskip->value());
	_fce->setResolution(comboboxResolution->currentItem());

	_fce->save();
	accept();
}
