/***************************************************************************
                          kemulatorwidget.cpp  -  main application widget
                             -------------------
    begin                : Wed Sep 19 09:59:41 EDT 2001
    copyright            : (C) 2001 by Scott Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kemulatorwidget.h"
#include <qlayout.h>
#include <klistbox.h>
#include <qdatetime.h>
#include <qstring.h>

KemulatorWidget::KemulatorWidget(QWidget* parent,  const char* name, WFlags fl) : QWidget(parent, name, fl)
{
	listbox = new KListBox(this, "listbox");

        qvBoxLayout = new QVBoxLayout(this);
	qvBoxLayout->addWidget(listbox);

	// signals and slots connections
	connect(listbox, SIGNAL(selected(int)), parent, SLOT(slotSelected(int)));
}

KemulatorWidget::~KemulatorWidget()
{
}

void KemulatorWidget::insertStringList(const QStringList &stringlist)
{
	listbox->clear();
	listbox->insertStringList(stringlist);
}

void KemulatorWidget::random()
{
	int count = listbox->count();
	if (count <= 0) return;

	int num = (QTime::currentTime().second() + 1) * QTime::currentTime().msec();
	listbox->setSelected((int)(num % count), true);
	listbox->ensureCurrentVisible();
}

int KemulatorWidget::currentItem()
{
	return listbox->currentItem();
}

void KemulatorWidget::setCurrentItem(int index)
{
	listbox->setCurrentItem(index);
}
