/***************************************************************************
                          kemulatorwidget.h  -  main application widget
                             -------------------
    begin                : Wed Sep 19 09:52:16 EDT 2001
    copyright            : (C) 2001 by Scott Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KEMULATORWIDGET_H
#define KEMULATORWIDGET_H

#include <qwidget.h>

class QVBoxLayout;
class KListBox;

class KemulatorWidget : public QWidget  {
public: 
	/** Constructor */
	KemulatorWidget(QWidget* parent = 0, const char* name = 0, WFlags fl = 0);
	/** Destructor */
	~KemulatorWidget();

	/** clear and insert text rows into the listbox */
	void insertStringList(const QStringList &stringlist);
	/** choose a random item on the list */
	void random();
	/** return the currently selected listbox item */
	int currentItem();
	/** set the listbox item */
	void setCurrentItem(int index);

public slots:
	/** */
	void selectionChanged(int);

private:
        /** a horizontal layout manager */
        QVBoxLayout* qvBoxLayout;
	/** the listbox to hold the ROM names */
	KListBox *listbox;
};

#endif // KEMULATORWIDGET_H
