/***************************************************************************
                          mess.cpp  -  MESS emulator
                             -------------------
    begin                : Tue Mar  6 20:01:53 EST 2001
    copyright            : (C) 2001 by Scott L. Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mess.h"
#include <qdir.h>
#include <qfileinfo.h>
#include <kprocess.h>
#include <iostream.h>

Mess::Mess(const QString &system) : Emulator()
{
	_system = system;
	refresh();
}

void Mess::refresh()
{
	Emulator::refresh();
	load();
	setRomList();
}

void Mess::load()
{
	QString group("MESS");
	group.append("_");
	group.append(_system);
	config->setGroup(group);
	Emulator::load();

	// Audio
	setDsp_plugin(config->readEntry("DSP Plugin", defaultDsp_plugin()));
	setTimer(config->readBoolEntry("Timer", defaultTimer()));
	setSound_mixer_plugin(config->readEntry("Sound Mixer Plugin", defaultSound_mixer_plugin()));
	setSound(config->readBoolEntry("Sound", defaultSound()));
	setSamples(config->readBoolEntry("Samples", defaultSamples()));
	setFakesound(config->readBoolEntry("Fake Sound", defaultFakesound()));
	setSamplefreq(config->readNumEntry("Sample Frequency", defaultSamplefreq()));
	setBufsize(config->readNumEntry("Buffer Size", defaultBufsize()));
	setVolume(config->readNumEntry("Volume", defaultVolume()));
	setAudiodevice(config->readEntry("Audio Device", defaultAudiodevice()));
	setMixerdevice(config->readEntry("Mixer Device", defaultMixerdevice()));

	// Input
	setJoytype(config->readNumEntry("Joystick Type", defaultJoytype()));
	setJoydevname(config->readEntry("Joystick Device Name", defaultJoydevname()));
	setAnalogstick(config->readBoolEntry("Analog Stick", defaultAnalogstick()));
	setHotrod(config->readBoolEntry("HotRod", defaultHotrod()));
	setHotrodse(config->readBoolEntry("HotRod SE", defaultHotrodse()));
	setMouse(config->readBoolEntry("Mouse", defaultMouse()));

	// Video
        setBpp(config->readNumEntry("Bpp", defaultBpp()));
        setHeightscale(config->readNumEntry("Height Scale", defaultHeightscale()));
        setWidthscale(config->readNumEntry("Width Scale", defaultWidthscale()));
        setScale(config->readNumEntry("Scale", defaultScale()));
        setAutodouble(config->readBoolEntry("Auto Double", defaultAutodouble()));
        setDirty(config->readBoolEntry("Dirty", defaultDirty()));
        setScanlines(config->readBoolEntry("Scanlines", defaultScanlines()));
        setArtwork(config->readBoolEntry("Artwork", defaultArtwork()));
        setFrameskipper(config->readNumEntry("Frameskipper", defaultFrameskipper()));
        setThrottle(config->readBoolEntry("Throttle", defaultThrottle()));
        setSleepidle(config->readBoolEntry("Sleepidle", defaultSleepidle()));
        setAutoframeskip(config->readBoolEntry("Auto Frameskip", defaultAutoframeskip()));
        setMaxautoframeskip(config->readNumEntry("Max Auto Frameskip", defaultMaxautoframeskip()));
        setFrameskip(config->readNumEntry("Frameskip", defaultFrameskip()));
        setBrightness(config->readNumEntry("Brightness", defaultBrightness()));
        setGamma_correction(config->readNumEntry("Gamma Correction", defaultGamma_correction()));
        setNorotate(config->readBoolEntry("No Rotate", defaultNorotate()));
        setRor(config->readBoolEntry("Rotate Right", defaultRor()));
        setRol(config->readBoolEntry("Rotate Left", defaultRol()));
        setFlipx(config->readBoolEntry("Flip X", defaultFlipx()));
        setFlipy(config->readBoolEntry("Flip Y", defaultFlipy()));
        setFullscreen(config->readBoolEntry("Fullscreen", defaultFullscreen()));
}

void Mess::save()
{
	QString group("MESS");
	group.append("_");
	group.append(_system);
	config->setGroup(group);
	Emulator::save();

	// Audio
	config->writeEntry("DSP Plugin", dsp_plugin());
	config->writeEntry("Timer", timer());
	config->writeEntry("Sound Mixer Plugin", sound_mixer_plugin());
	config->writeEntry("Sound", sound());
	config->writeEntry("Samples", samples());
	config->writeEntry("Fake Sound", fakesound());
	config->writeEntry("Sample Frequency", samplefreq());
	config->writeEntry("Buffer Size", bufsize());
	config->writeEntry("Volume", volume());
	config->writeEntry("Audio Device", audiodevice());
	config->writeEntry("Mixer Device", mixerdevice());

	// Input
	config->writeEntry("Joystick Type", joytype());
	config->writeEntry("Joystick Device Name", joydevname());
	config->writeEntry("Analog Stick", analogstick());
	config->writeEntry("HotRod", hotrod());
	config->writeEntry("HotRod SE", hotrodse());
	config->writeEntry("Mouse", mouse());

	// Video
        config->writeEntry("Bpp", bpp());
        config->writeEntry("Height Scale", heightscale());
        config->writeEntry("Width Scale", widthscale());
        config->writeEntry("Scale", scale());
        config->writeEntry("Auto Double", autodouble());
        config->writeEntry("Dirty", dirty());
        config->writeEntry("Scanlines", scanlines());
        config->writeEntry("Artwork", artwork());
        config->writeEntry("Frameskipper", frameskipper());
        config->writeEntry("Throttle", throttle());
        config->writeEntry("Sleepidle", sleepidle());
        config->writeEntry("Auto Frameskip", autoframeskip());
        config->writeEntry("Max Auto Frameskip", maxautoframeskip());
        config->writeEntry("Frameskip", frameskip());
        config->writeEntry("Brightness", brightness());
        config->writeEntry("Gamma Correction", gamma_correction());
        config->writeEntry("No Rotate", norotate());
        config->writeEntry("Rotate Right", ror());
        config->writeEntry("Rotate Left", rol());
        config->writeEntry("Flip X", flipx());
        config->writeEntry("Flip Y", flipy());
        config->writeEntry("Fullscreen", fullscreen());
}

// TODO - Could probably optimize the arguments string creation
void Mess::emulate(int index)
{
//xmess <system> [game] [options]
	// Executable
	QString command;
	command.append(executable());
	command.append(" ");

	// Executable
	command.append(_system);
	command.append(" ");

	// ROM
	if ((_system == "apple2c") || (_system == "apple2e"))
		command.append("-flop \"");
	else
		command.append("-cart \"");
	command.append(romDir());
	command.append("/");
//	command.append(_romList[index].left(_romList[index].length()-4));
/*	if (_romList[index].right(3) == "zip")
	{
		command.append(_romList[index].left(_romList[index].length()-4));
		command.append(".");
		if (_system == "apple2e") command.append("dsk");
		else if (_system == "apple2c") command.append("dsk");
		else if (_system == "a5200") command.append("bin");
		else if (_system == "a7800") command.append("a78");
		else if (_system == "coleco") command.append("rom");
		else if (_system == "genesis") command.append("smd");
		else if (_system == "nespal") command.append("nes");
		else if (_system == "ti99_4a") command.append("bin");
		else if (_system == "vectrex") command.append("gam");
		else command.append(_system);
	}
	else if(_romList[index].right(2) == "gz")
		command.append(_romList[index].left(_romList[index].length()-3));
	else  */
		command.append(_romList[index].left(_romList[index].length()-0));
	command.append("\" ");

	// Audio
	if (dsp_plugin().length() > 0)
	{
		command.append("-dsp-plugin ");
		command.append(dsp_plugin());
		command.append(" ");
	}
	if (timer()) command.append("-timer ");
	if (sound_mixer_plugin().length() > 0)
	{
		command.append("-sound-mixer-plugin ");
		command.append(sound_mixer_plugin());
		command.append(" ");
	}
	if (sound()) command.append("-sound "); else command.append("-nosound ");
	if (samples()) command.append("-samples "); else command.append("-nosamples ");
	if (fakesound()) command.append("-fakesound ");
	command.append("-samplefreq ");
	command.append(QString::number(samplefreq()));
	command.append(" ");
	command.append("-bufsize ");
	command.append(QString::number(bufsize()));
	command.append(" ");
	command.append("-volume ");
	command.append(QString::number(volume()));
	command.append(" ");
	if (audiodevice().length() > 0)
	{
		command.append("-audiodevice ");
		command.append(audiodevice());
		command.append(" ");
	}
	if (mixerdevice().length() > 0)
	{
		command.append("-mixerdevice ");
		command.append(mixerdevice());
		command.append(" ");
	}

	// Input
	command.append("-joytype ");
	command.append(QString::number(joytype()));
	command.append(" ");
	if (joydevname().length() > 0)
	{
		command.append("-joydevname ");
		command.append(joydevname());
		command.append(" ");
	}
	if (analogstick()) command.append("-analogstick "); else command.append("-noanalogstick ");
	if (mouse()) command.append("-mouse "); else command.append("-nomouse ");
	if (hotrod()) command.append("-hotrod ");
	if (hotrodse()) command.append("-hotrodse ");

	// Video
        if (autoframeskip()) command.append("-autoframeskip "); else command.append("-noautoframeskip ");
        if (fullscreen()) command.append("-x11 1 ");
        if (scanlines()) command.append("-scanlines "); else command.append("-noscanlines ");
        if (sleepidle()) command.append("-sleepidle "); else command.append("-nosleepidle ");
        if (throttle()) command.append("-throttle "); else command.append("-nothrottle ");
        command.append("-bpp ");
        command.append(QString::number(bpp()));
        command.append(" ");
        command.append("-scale ");
        command.append(QString::number(scale()));
        command.append(" ");
        command.append("-frameskipper ");
        command.append(QString::number(frameskipper()));
        command.append(" ");
        command.append("-maxautoframeskip ");
        command.append(QString::number(maxautoframeskip()));
        command.append(" ");
        command.append("-frameskip ");
        command.append(QString::number(frameskip()));
        command.append(" ");

	// Run it
	command.append(" &");
	cout << command << endl;
	KShellProcess process;
	process << command;
        process.start(KProcess::DontCare, KProcess::NoCommunication);
}

QString Mess::defaultRomDir() const
{
	QString romdir;
	romdir.append("/usr/local/games/");
	romdir.append(_system);
	romdir.append("/roms/");
	return romdir;
}
