/***************************************************************************
                          messdlgimpl.cpp  -  description
                             -------------------
    begin                : Wed Sep 19 2001
    copyright            : (C) 2001 by Scott Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "messdlgimpl.h"
#include "mess.h"
#include <qstring.h>
#include <kfiledialog.h>
#include <qfiledialog.h>
#include <qlabel.h>
#include <qtabwidget.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qspinbox.h>

MessDlgImpl::MessDlgImpl(const QString &system, QWidget *parent, const char *name, bool modal, WFlags fl) : MessDlg(parent, name, modal, fl) {
	_mess = new Mess(system);
	QString name;
	name.append("MESS Configuration - ");
	name.append(system);
	setCaption(name);

	// Filesystem
	lineeditExecutable->setText(_mess->executable());
	lineeditRom->setText(_mess->romDir());

	// Audio
	checkboxSound->setChecked(_mess->sound());
	checkboxSamples->setChecked(_mess->samples());
	checkboxFakesound->setChecked(_mess->fakesound());
	checkboxTimer->setChecked(_mess->timer());
	spinboxSamplefreq->setValue(_mess->samplefreq());
	spinboxVolume->setValue(_mess->volume());
	spinboxBufsize->setValue(_mess->bufsize());
	lineeditDsp_plugin->setText(_mess->dsp_plugin());
	lineeditSound_mixer_plugin->setText(_mess->sound_mixer_plugin());
	lineeditAudiodevice->setText(_mess->audiodevice());
	lineeditMixerdevice->setText(_mess->mixerdevice());

	// Input
	comboboxJoytype->setCurrentItem(_mess->joytype());
	lineeditJoydevname->setText(_mess->joydevname());
	checkboxAnalogstick->setChecked(_mess->analogstick());
	checkboxHotrod->setChecked(_mess->hotrod());
	checkboxHotrodse->setChecked(_mess->hotrodse());
	checkboxMouse->setChecked(_mess->mouse());

	// Video
        checkboxAutoframeskip->setChecked(_mess->autoframeskip());
        checkboxDirty->setChecked(_mess->dirty());
        checkboxFullscreen->setChecked(_mess->fullscreen());
        checkboxScanlines->setChecked(_mess->scanlines());
        checkboxSleepidle->setChecked(_mess->sleepidle());
        checkboxThrottle->setChecked(_mess->throttle());
        spinboxBpp->setValue(_mess->bpp());
        spinboxScale->setValue(_mess->scale());
        comboboxFrameskipper->setCurrentItem(_mess->frameskipper());
        spinboxMaxautoframeskip->setValue(_mess->maxautoframeskip());
        spinboxFrameskip->setValue(_mess->frameskip());
}

MessDlgImpl::~MessDlgImpl(){
	delete _mess;
}

void MessDlgImpl::slotBrowseExecutable()
{
	QString string(KFileDialog::getOpenFileName(_mess->executable()));
	if (!string.isNull()) lineeditExecutable->setText(string);
}

void MessDlgImpl::slotBrowseRom()
{
	QString string(KFileDialog::getExistingDirectory(_mess->romDir()));
	if (!string.isNull()) lineeditRom->setText(string);
}

void MessDlgImpl::slotDefaults()
{
QString tabLabel = tabMess->tabLabel(tabMess->currentPage());

	if (tabLabel == "Filesystem")
	{
		lineeditExecutable->setText(_mess->defaultExecutable());
		lineeditRom->setText(_mess->defaultRomDir());
	}

	if (tabLabel == "Audio")
	{
		checkboxSound->setChecked(_mess->defaultSound());
		checkboxSamples->setChecked(_mess->defaultSamples());
		checkboxFakesound->setChecked(_mess->defaultFakesound());
		checkboxTimer->setChecked(_mess->defaultTimer());
		spinboxSamplefreq->setValue(_mess->defaultSamplefreq());
		spinboxVolume->setValue(_mess->defaultVolume());
		spinboxBufsize->setValue(_mess->defaultBufsize());
		lineeditDsp_plugin->setText(_mess->defaultDsp_plugin());
		lineeditSound_mixer_plugin->setText(_mess->defaultSound_mixer_plugin());
		lineeditAudiodevice->setText(_mess->defaultAudiodevice());
		lineeditMixerdevice->setText(_mess->defaultMixerdevice());
	}

	if (tabLabel == "Input")
	{
		comboboxJoytype->setCurrentItem(_mess->defaultJoytype());
		lineeditJoydevname->setText(_mess->defaultJoydevname());
		checkboxAnalogstick->setChecked(_mess->defaultAnalogstick());
		checkboxHotrod->setChecked(_mess->defaultHotrod());
		checkboxHotrodse->setChecked(_mess->defaultHotrodse());
		checkboxMouse->setChecked(_mess->defaultMouse());
	}

	if (tabLabel == "Video")
	{
                checkboxAutoframeskip->setChecked(_mess->defaultAutoframeskip());
                checkboxDirty->setChecked(_mess->defaultDirty());
                checkboxFullscreen->setChecked(_mess->defaultFullscreen());
                checkboxScanlines->setChecked(_mess->defaultScanlines());
                checkboxSleepidle->setChecked(_mess->defaultSleepidle());
                checkboxThrottle->setChecked(_mess->defaultThrottle());
                spinboxBpp->setValue(_mess->defaultBpp());
                spinboxScale->setValue(_mess->defaultScale());
                comboboxFrameskipper->setCurrentItem(_mess->defaultFrameskipper());
                spinboxMaxautoframeskip->setValue(_mess->defaultMaxautoframeskip());
                spinboxFrameskip->setValue(_mess->defaultFrameskip());
	}
}

void MessDlgImpl::slotSave()
{
	// Filesystem
	_mess->setExecutable(lineeditExecutable->text());
	_mess->setRomDir(lineeditRom->text());

	// Audio
	_mess->setDsp_plugin(lineeditDsp_plugin->text());
	_mess->setTimer(checkboxTimer->isChecked());
	_mess->setSound_mixer_plugin(lineeditSound_mixer_plugin->text());
	_mess->setSound(checkboxSound->isChecked());
	_mess->setSamples(checkboxSamples->isChecked());
	_mess->setFakesound(checkboxFakesound->isChecked());
	_mess->setSamplefreq(spinboxSamplefreq->value());
	_mess->setBufsize(spinboxBufsize->value());
	_mess->setVolume(spinboxVolume->value());
	_mess->setAudiodevice(lineeditAudiodevice->text());
	_mess->setMixerdevice(lineeditMixerdevice->text());

	// Input
	_mess->setJoytype(comboboxJoytype->currentItem());
	_mess->setJoydevname(lineeditJoydevname->text());
	_mess->setAnalogstick(checkboxAnalogstick->isChecked());
	_mess->setHotrod(checkboxHotrod->isChecked());
	_mess->setHotrodse(checkboxHotrodse->isChecked());
	_mess->setMouse(checkboxMouse->isChecked());

	// Video
        _mess->setAutoframeskip(checkboxAutoframeskip->isChecked());
        _mess->setDirty(checkboxDirty->isChecked());
        _mess->setFullscreen(checkboxFullscreen->isChecked());
        _mess->setScanlines(checkboxScanlines->isChecked());
        _mess->setSleepidle(checkboxSleepidle->isChecked());
        _mess->setThrottle(checkboxThrottle->isChecked());
        _mess->setBpp(spinboxBpp->value());
        _mess->setScale(spinboxScale->value());
        _mess->setFrameskipper(comboboxFrameskipper->currentItem());
        _mess->setMaxautoframeskip(spinboxMaxautoframeskip->value());
        _mess->setFrameskip(spinboxFrameskip->value());

	_mess->save();
	accept();
}
