/***************************************************************************
                          snes9x.h  -  Snes9x emulator settings
                             -------------------
    begin                : Fri Nov  2 18:29:50 EST 2001
    copyright            : (C) 2001 by Scott L. Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SNES9x_H
#define SNES9x_H

#include "emulator.h"
#include <qstring.h>

class Snes9x : public Emulator
{ 
public:
	/** Constructor */
	Snes9x();
	/** Destructor */
	~Snes9x() {};

	/** recreate the romlist */
	virtual void refresh();

	/** load the emulator settings */
	virtual void load();
	/** save the emulator settings */
	virtual void save();

	/** command to run the emulator */
	virtual void emulate(int);

	/** returns the default executable */
	virtual QString defaultExecutable() const { return "snes9x"; }
	/** returns the default ROM directory */
	virtual QString defaultRomDir() const { return "/usr/local/games/snes/roms/"; }

	/** Audio */
	/** return the sound */
	bool sound() const { return _sound; }
	/** return the stereo */
	bool stereo() const { return _stereo; }
	/** return the soundquality */
	int soundquality() const { return _soundquality; }
	/** return the buffersize */
	int buffersize() const { return _buffersize; }
	/** return the echo */
	bool echo() const { return _echo; }
	/** return the envx */
	bool envx() const { return _envx; }
	/** return the samplecaching */
	bool samplecaching() const { return _samplecaching; }
	/** return the mastervolume */
	bool mastervolume() const { return _mastervolume; }
	/** return the soundsync */
	bool soundsync() const { return _soundsync; }
	/** return the soundsync2 */
	bool soundsync2() const { return _soundsync2; }
	/** return the interpolatedsound */
	bool interpolatedsound() const { return _interpolatedsound; }
	/** return the threadsound */
	bool threadsound() const { return _threadsound; }
	/** return the altsampledecode */
	bool altsampledecode() const { return _altsampledecode; }
	/** Cheat */
	/** return the gamegenie */
	QString gamegenie() const { return _gamegenie; }
	/** return the actionreplay */
	QString actionreplay() const { return _actionreplay; }
	/** return the goldfinger */
	QString goldfinger() const { return _goldfinger; }
	/** Input */
	/** return the mouse */
	bool mouse() const { return _mouse; }
	/** return the superscope */
	bool superscope() const { return _superscope; }
	/** return the joy */
	bool joy() const { return _joy; }
	/** return the swapjoypads */
	bool swapjoypads() const { return _swapjoypads; }
	/** return the joydev1 */
	QString joydev1() const { return _joydev1; }
	/** return the joydev2 */
	QString joydev2() const { return _joydev2; }
	/** return the joymap1 */
	QString joymap1() const { return _joymap1; }
	/** return the joymap2 */
	QString joymap2() const { return _joymap2; }
	/** Netplay */
	/** return the multiplayer5 */
	bool multiplayer5() const { return _multiplayer5; }
	/** return the net */
	bool net() const { return _net; }
	/** return the server */
	QString server() const { return _server; }
	/** return the port */
	int port() const { return _port; }
	/** ROM */
	/** return the interleaved */
	bool interleaved() const { return _interleaved; }
	/** return the interleaved2 */
	bool interleaved2() const { return _interleaved2; }
	/** return the hirom */
	bool hirom() const { return _hirom; }
	/** return the lorom */
	bool lorom() const { return _lorom; }
	/** return the header */
	bool header() const { return _header; }
	/** return the noheader */
	bool noheader() const { return _noheader; }
	/** return the pal */
	bool pal() const { return _pal; }
	/** return the ntsc */
	bool ntsc() const { return _ntsc; }
	/** return the layering */
	bool layering() const { return _layering; }
	/** return the loadsnapshot */
	QString loadsnapshot() const { return _loadsnapshot; }
	/** return the hdma */
	bool hdma() const { return _hdma; }
	/** return the speedhacks */
	bool speedhacks() const { return _speedhacks; }
	/** return the windows */
	bool windows() const { return _windows; }
	/** Video */
	/** return the transparency */
	bool transparency() const { return _transparency; }
	/** return the sixteen */
	bool sixteen() const { return _sixteen; }
	/** return the hires */
	bool hires() const { return _hires; }
	/** return the interpolate */
	bool interpolate() const { return _interpolate; }
	/** return the interpolate2 */
	bool interpolate2() const { return _interpolate2; }
	/** return the interpolate3 */
	bool interpolate3() const { return _interpolate3; }
	/** return the interpolate4 */
	bool interpolate4() const { return _interpolate4; }
	/** return the interpolate5 */
	bool interpolate5() const { return _interpolate5; }
	/** return the modeswitch */
	bool modeswitch() const { return _modeswitch; }
	/** return the fullscreen */
	bool fullscreen() const { return _fullscreen; }
	/** return the scale */
	bool scale() const { return _scale; }
	/** return the displayframerate */
	bool displayframerate() const { return _displayframerate; }
	/** return the frameskip */
	int frameskip() const { return _frameskip; }
	/** return the frametime */
	int frametime() const { return _frametime; }
	/** return the cycles */
	int cycles() const { return _cycles; }

	/** Audio */
	/** return the default sound */
	bool defaultSound() const { return true; }
	/** return the default stereo */
	bool defaultStereo() const { return true; }
	/** return the default soundquality */
	int defaultSoundquality() const { return 4; }
	/** return the default buffersize */
	int defaultBuffersize() const { return 4096; }
	/** return the default echo */
	bool defaultEcho() const { return false; }
	/** return the default envx */
	bool defaultEnvx() const { return false; }
	/** return the default samplecaching */
	bool defaultSamplecaching() const { return false; }
	/** return the default mastervolume */
	bool defaultMastervolume() const { return false; }
	/** return the default soundsync */
	bool defaultSoundsync() const { return false; }
	/** return the default soundsync2 */
	bool defaultSoundsync2() const { return false; }
	/** return the default interpolatedsound */
	bool defaultInterpolatedsound() const { return false; }
	/** return the default threadsound */
	bool defaultThreadsound() const { return false; }
	/** return the default altsampledecode */
	bool defaultAltsampledecode() const { return false; }
	/** Cheat */
	/** return the default gamegenie */
	QString defaultGamegenie() const { return 0; }
	/** return the default actionreplay */
	QString defaultActionreplay() const { return 0; }
	/** return the default goldfinger */
	QString defaultGoldfinger() const { return 0; }
	/** Input */
	/** return the default mouse */
	bool defaultMouse() const { return true; }
	/** return the default superscope */
	bool defaultSuperscope() const { return false; }
	/** return the default joy */
	bool defaultJoy() const { return true; }
	/** return the default swapjoypads */
	bool defaultSwapjoypads() const { return false; }
	/** return the default joydev1 */
	QString defaultJoydev1() const { return 0; }
	/** return the default joydev2 */
	QString defaultJoydev2() const { return 0; }
	/** return the default joymap1 */
	QString defaultJoymap1() const { return 0; }
	/** return the default joymap2 */
	QString defaultJoymap2() const { return 0; }
	/** Netplay */
	/** return the default multiplayer5 */
	bool defaultMultiplayer5() const { return false; }
	/** return the default net */
	bool defaultNet() const { return false; }
	/** return the default server */
	QString defaultServer() const { return "localhost"; }
	/** return the default port */
	int defaultPort() const { return 6096; }
	/** ROM */
	/** return the default interleaved */
	bool defaultInterleaved() const { return false; }
	/** return the default interleaved2 */
	bool defaultInterleaved2() const { return false; }
	/** return the default hirom */
	bool defaultHirom() const { return false; }
	/** return the default lorom */
	bool defaultLorom() const { return false; }
	/** return the default header */
	bool defaultHeader() const { return false; }
	/** return the default noheader */
	bool defaultNoheader() const { return false; }
	/** return the default pal */
	bool defaultPal() const { return false; }
	/** return the default ntsc */
	bool defaultNtsc() const { return false; }
	/** return the default layering */
	bool defaultLayering() const { return false; }
	/** return the default loadsnapshot */
	QString defaultLoadsnapshot() const { return 0; }
	/** return the default hdma */
	bool defaultHdma() const { return true; }
	/** return the default speedhacks */
	bool defaultSpeedhacks() const { return true; }
	/** return the default windows */
	bool defaultWindows() const { return true; }
	/** Video */
	/** return the default transparency */
	bool defaultTransparency() const { return false; }
	/** return the default sixteen */
	bool defaultSixteen() const { return false; }
	/** return the default hires */
	bool defaultHires() const { return false; }
	/** return the default interpolate */
	bool defaultInterpolate() const { return false; }
	/** return the default interpolate2 */
	bool defaultInterpolate2() const { return false; }
	/** return the default interpolate3 */
	bool defaultInterpolate3() const { return true; }
	/** return the default interpolate4 */
	bool defaultInterpolate4() const { return false; }
	/** return the default interpolate5 */
	bool defaultInterpolate5() const { return false; }
	/** return the default modeswitch */
	bool defaultModeswitch() const { return true; }
	/** return the default fullscreen */
	bool defaultFullscreen() const { return true; }
	/** return the default scaleu*/
	bool defaultScale() const { return true; }
	/** return the default displayframerate */
	bool defaultDisplayframerate() const { return false; }
	/** return the default frameskip */
	int defaultFrameskip() const { return -1; }
	/** return the default frametime */
	int defaultFrametime() const { return -1; }
	/** return the default cycles */
	int defaultCycles() const { return 100; }

	/** Audio */
	/** set the default sound */
	void setSound(bool sound) { _sound = sound; }
	/** set the default stereo */
	void setStereo(bool stereo) { _stereo = stereo; }
	/** set the default soundquality */
	void setSoundquality(int soundquality) { _soundquality = soundquality; }
	/** set the default buffersize */
	void setBuffersize(int buffersize) { _buffersize = buffersize; }
	/** set the default echo */
	void setEcho(bool echo) { _echo = echo; }
	/** set the default envx */
	void setEnvx(bool envx) { _envx = envx; }
	/** set the default samplecaching */
	void setSamplecaching(bool samplecaching) { _samplecaching = samplecaching; }
	/** set the default mastervolume */
	void setMastervolume(bool mastervolume) { _mastervolume = mastervolume; }
	/** set the default soundsync */
	void setSoundsync(bool soundsync) { _soundsync = soundsync; }
	/** set the default soundsync2 */
	void setSoundsync2(bool soundsync2) { _soundsync2 = soundsync2; }
	/** set the default interpolatedsound */
	void setInterpolatedsound(bool interpolatedsound) { _interpolatedsound = interpolatedsound; }
	/** set the default threadsound */
	void setThreadsound(bool threadsound) { _threadsound = threadsound; }
	/** set the default altsampledecode */
	void setAltsampledecode(bool altsampledecode) { _altsampledecode = altsampledecode; }
	/** Cheat */
	/** set the gamegenie */
	void setGamegenie(const QString &gamegenie) { _gamegenie = gamegenie; }
	/** set the actionreplay */
	void setActionreplay(const QString &actionreplay) { _actionreplay = actionreplay; }
	/** set the goldfinger */
	void setGoldfinger(const QString &goldfinger) { _goldfinger = goldfinger; }
	/** Input */
	/** set the mouse */
	void setMouse(bool mouse) { _mouse = mouse; }
	/** set the superscope */
	void setSuperscope(bool superscope) { _superscope = superscope; }
	/** set the joy */
	void setJoy(bool joy) { _joy = joy; }
	/** set the swapjoypads */
	void setSwapjoypads(bool swapjoypads) { _swapjoypads = swapjoypads; }
	/** set the joydev1 */
	void setJoydev1(const QString &joydev1) { _joydev1 = joydev1; }
	/** set the joydev2 */
	void setJoydev2(const QString &joydev2) { _joydev2 = joydev2; }
	/** set the joymap1 */
	void setJoymap1(const QString &joymap1) { _joymap1 = joymap1; }
	/** set the joymap2 */
	void setJoymap2(const QString &joymap2) { _joymap2 = joymap2; }
	/** Netplay */
	/** set the multiplayer5 */
	void setMultiplayer5(bool multiplayer5) { _multiplayer5 = multiplayer5; }
	/** set the net */
	void setNet(bool net) { _net = net; }
	/** set the server */
	void setServer(const QString &server) { _server = server; }
	/** set the port */
	void setPort(int port) { _port = port; }
	/** ROM */
	/** set the interleaved */
	void setInterleaved(bool interleaved) { _interleaved = interleaved; }
	/** set the interleaved2 */
	void setInterleaved2(bool interleaved2) { _interleaved2 = interleaved2; }
	/** set the hirom */
	void setHirom(bool hirom) { _hirom = hirom; }
	/** set the lorom */
	void setLorom(bool lorom) { _lorom = lorom; }
	/** set the header */
	void setHeader(bool header) { _header = header; }
	/** set the noheader */
	void setNoheader(bool noheader) { _noheader = noheader; }
	/** set the pal */
	void setPal(bool pal) { _pal = pal; }
	/** set the ntsc */
	void setNtsc(bool ntsc) { _ntsc = ntsc; }
	/** set the layering */
	void setLayering(bool layering) { _layering = layering; }
	/** set the loadsnapshot */
	void setLoadsnapshot(const QString &loadsnapshot) { _loadsnapshot = loadsnapshot; }
	/** set the hdma */
	void setHdma(bool hdma) { _hdma = hdma; }
	/** set the speedhacks */
	void setSpeedhacks(bool speedhacks) { _speedhacks = speedhacks; }
	/** set the windows */
	void setWindows(bool windows) { _windows = windows; }
	/** Video */
	/** set the transparency */
	void setTransparency(bool transparency) { _transparency = transparency; }
	/** set the sixteen */
	void setSixteen(bool sixteen) { _sixteen = sixteen; }
	/** set the hires */
	void setHires(bool hires) { _hires = hires; }
	/** set the interpolate */
	void setInterpolate(bool interpolate) { _interpolate = interpolate; }
	/** set the interpolate2 */
	void setInterpolate2(bool interpolate2) { _interpolate2 = interpolate2; }
	/** set the interpolate3 */
	void setInterpolate3(bool interpolate3) { _interpolate3 = interpolate3; }
	/** set the interpolate4 */
	void setInterpolate4(bool interpolate4) { _interpolate4 = interpolate4; }
	/** set the interpolate5 */
	void setInterpolate5(bool interpolate5) { _interpolate5 = interpolate5; }
	/** set the modeswitch */
	void setModeswitch(bool modeswitch) { _modeswitch = modeswitch; }
	/** set the fullscreen */
	void setFullscreen(bool fullscreen) { _fullscreen = fullscreen; }
	/** set the scale */
	void setScale(bool scale) { _scale = scale; }
	/** set the displayframerate */
	void setDisplayframerate(bool displayframerate) { _displayframerate = displayframerate; }
	/** set the frameskip */
	void setFrameskip(int frameskip) { _frameskip = frameskip; }
	/** set the frametime */
	void setFrametime(int frametime) { _frametime = frametime; }
	/** set the cycles */
	void setCycles(int cycles) { _cycles = cycles; }

protected:
	/** Audio */
	/** Enable digital sound output (default: enabled) */
	bool _sound;
	/** Enable stereo sound (default: mono sound) */
	bool _stereo;                   
	/** Sound sample playback rate/quality, 0-7 (default 4) 0 - off, 1 - 8192, 2 - 11025, 3 - 16500, 4 - 22050 (default), 5 - 29300, 6 - 36600, 7 - 44000 */
	int _soundquality;
	/** Sound playback buffer size in bytes 128-4096 */
	int _buffersize;
	/** Turn on sound echo and FIR filter effects */
	bool _echo;
	/** Enable volume envelope height reading by the sound CPU */
	bool _envx;
	/** Enable  decompressed  sound  sample caching */
	bool _samplecaching;
	/** Enable  emulation of the sound DSP master volume control */
	bool _mastervolume;
	/** Uses another method to sync the game and the actual sound */
	bool _soundsync;
	/** Uses yet another method to sync the game and the actual sound */
	bool _soundsync2;
	/** Enable sound interpolation */
	bool _interpolatedsound;
	/** snes9x uses generates another thread */
	bool _threadsound;
	/** Snes9x uses an alternative method to decode the sound */
	bool _altsampledecode;

	/** Cheat */
	/** Supply  a Game Genie code for the current ROM */
	QString _gamegenie;
	/** Supply a Pro-Action Reply code for the current ROM */
	QString _actionreplay;
	/** Supply a Gold Finger code for the current ROM */
	QString _goldfinger;

	/** Input */
	/** Enable mouse emulation. */
	bool _mouse;
	/** Enable SuperScope emulation. */
	bool _superscope;
	 /** Joystick support. */
	bool _joy ;
	/** Swaps the both joypads.*/
	bool _swapjoypads;
	/** Supply device for joypad number 1. */
	QString _joydev1;
	/** Supply device for joypad number 2. */
	QString _joydev2;
	/** Assign  the  buttons  by giving eight number from 0 to 7. Default Map is: 0 1 2 3 4 5 6 7, which corresponds to A B X Y TL TR Start Select. */
	QString _joymap1;
	/** Assign the buttons by giving eight number from 0 to 7. Default Map is: 0 1 2 3 4 5 6 7, which corresponds to A  B  X  Y  TL  TR Start Select. */
	QString _joymap2;

	/** Netplay */
	/** Enables Multiplayer TAP Support. */
	bool _multiplayer5;
	/** Enable Netplay. */
	bool _net;
	/** Name of the s9xserver to connect to. */
	QString _server;
	/** Specify what port to connect to.  Default: 6096 */
	int _port;

	/** ROM */
	/** Force interleaved ROM image format */
	bool _interleaved;
	/** Force alternate interleaved format (i.e. most Super FX games) */
	bool _interleaved2;
	/** Force Hi-ROM memory map for ROMs where the Hi-ROM header test fails */
	bool _hirom;
	/** Force Lo-ROM memory map for ROMs where the Hi-ROM header test fails */
	bool _lorom;
	/** Force  the  detection  of a ROM image header */
	bool _header;
	/** Force Snes9x into thinking no ROM image header is present */
	bool _noheader;
	/** Fool ROM into thinking this is a PAL SNES system and adjust frame time to 20ms (50 frames per second) */
	bool _pal;
	/** Fool ROM into thinking this is a NTSC SNES system and adjust frame time to 16.7ms (60 frames per second) */
	bool _ntsc;
	/** Swap background layer priorities from background involved in sub-screen addition/subtraction */
	bool _layering;
	/** Load snapshot file and restart game from saved position */	
	QString _loadsnapshot;
	/** Turn on the H-DMA emulation */
	bool _hdma;
	/** Turn on a couple of speed hacks */
	bool _speedhacks;
	/** Enable graphics windows emulation */
	bool _windows;

	/** Video */
	/** Enable transparency effects */
	bool _transparency;
	/** Enable 16-bit internal screen rendering */
	bool _sixteen;
	/** Enable support for SNES hi-res and interlace modes */
	bool _hires;
	/** Enables 'TV mode', hires support, 16-bit internal rendering and transparency effects */
	bool _interpolate;
	/** Enables Kreed's Super 2xSaI image processing mode */
	bool _interpolate2;
	/** Enables Kreed's Super Eagle image processing mode */
	bool _interpolate3;
	/** Enables Kreed's 2xSaI image processing mode */
	bool _interpolate4;
	/** Enables Kreed's software bi-linear filtering and image scaling mode */
	bool _interpolate5;
	/** Enables switch video mode */
	bool _modeswitch;
	/** Start the emulator in full screen mode */
	bool _fullscreen;
	/** Stretch the SNES display to fit the whole of the computer display */
	bool _scale;
	/** Display a frame rate counter superimposed over the bottom, left-hand corner */
	bool _displayframerate;
	/** Set this value to deliberately fix the frame skip rate and disable auto-speed regulation */
	int _frameskip;
	/** try to maintain a constant game and music speed locked to this value */
	int _frametime;
	/** Percentage of CPU cycles to execute per scan line */
	int _cycles;
};

#endif // SNES9x_H
